/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.twoPortInsertionLoss;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.measurement.CommonLossMeasurementSettings;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;

public abstract class InsertionLossMeasurementSettings
extends CommonLossMeasurementSettings {
    public static final String KEY_OPT_MODE = "optMode";
    public static final String KEY_LIMITS_TOGGLE = "insertionLossLimitsToggle";
    public static final String KEY_LIMITS_UPPER = "insertionLossUpperLimit";
    public static final String KEY_LIMITS_LOWER = "insertionLossLowerLimit";
    public final int VALUE_OPT_MODE_ACCURACY = 0;
    public final int VALUE_OPT_MODE_RANGE = 1;
    protected LongActuator sourceLevel;
    protected LongActuator stashedManualValue;
    protected RestrictedListActuator sourceLevelAutoManual;
    protected ListActuator optMode;
    protected ListActuator limitsToggle;
    protected LongActuator upperLimit;
    protected LongActuator lowerLimit;
    protected boolean doingLimitSetAll = true;

    public InsertionLossMeasurementSettings(String string) {
        super(string);
    }

    protected void addAdditionalActuators() {
        super.addAdditionalActuators();
        this.limitsToggle = new ListActuator(this.DISPLAY_TOPIC, KEY_LIMITS_TOGGLE, Text.Limits, this.createOnOffValueSet());
        this.upperLimit = LongActuator.createPower(this.DISPLAY_TOPIC, KEY_LIMITS_UPPER, Text.get("InsertionLoss_MinLoss_Limit"));
        this.lowerLimit = LongActuator.createPower(this.DISPLAY_TOPIC, KEY_LIMITS_LOWER, Text.get("InsertionLoss_MaxLoss_Limit"));
        RangeValidator rangeValidator = new RangeValidator(-100000L, 100000L);
        this.lowerLimit.setValidator(rangeValidator);
        this.upperLimit.setValidator(rangeValidator);
        this.add(this.limitsToggle);
        this.add(this.upperLimit);
        this.add(this.lowerLimit);
    }

    public ListActuator getLimitsToggle() {
        return this.limitsToggle;
    }

    public LongActuator getUpperLimit() {
        return this.upperLimit;
    }

    public LongActuator getLowerLimit() {
        return this.lowerLimit;
    }

    protected static class RestrictedListActuator
    extends ListActuator {
        protected boolean onlyAllowAuto;

        public RestrictedListActuator(String string, String string2, String string3, Value[] valueArray) {
            super(string, string2, string3, valueArray);
        }

        public void setOnlyAllowAuto(boolean bl) {
            this.onlyAllowAuto = bl;
        }

        void setValue(Value value) {
            if (this.onlyAllowAuto) {
                this.setValueObject(this.getValue(1));
            } else {
                this.setValueObject(value);
            }
        }
    }
}

