/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.twoPortInsertionLoss;

import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.measurement.twoPortInsertionLoss.InsertionLossMeasurement;
import elgato.measurement.twoPortInsertionLoss.InsertionLossMeasurementSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Vector;

public class InsertionLossMetrics
extends MeasurementMetrics {
    private ReadingField[] readingFields;
    private final Vector labels = new Vector();
    DynamicLabel insertionLossGainLabel;
    DynamicLabel averageLossGain;
    DynamicLabel gainDescription;

    public InsertionLossMetrics() {
        this.setLayout(new TableLayout(new float[][]{{0.6f, 15.0f, -1.0f}, {52.0f, 18.0f}}));
        this.insertionLossGainLabel = new DynamicLabel(4, this.labelColor, this.labelFont){

            protected String formatValue(Measurement measurement) {
                return Text.Avg_Insertion_Loss;
            }
        };
        this.add((Component)this.addLabel(this.insertionLossGainLabel), "0, 0, f, c");
        this.averageLossGain = new DynamicLabel(3, this.valueColor, this.valueFont){

            protected String formatValue(Measurement measurement) {
                InsertionLossMeasurement insertionLossMeasurement = (InsertionLossMeasurement)measurement;
                InsertionLossMeasurementSettings insertionLossMeasurementSettings = insertionLossMeasurement.getSettings();
                String string = "";
                if (insertionLossMeasurementSettings.getLimitsToggle().longValue() == 1L) {
                    long l = insertionLossMeasurementSettings.getUpperLimit().longValue();
                    long l2 = insertionLossMeasurementSettings.getLowerLimit().longValue();
                    int n = insertionLossMeasurement.getAverageInsertionLoss();
                    if (TraceChart.getInvert()) {
                        n = -n;
                    }
                    if ((long)n < l || (long)n > l2) {
                        this.setChunkColor(0, Color.red);
                        string = " (F)";
                    } else {
                        this.setChunkColor(0, MeasurementMetrics.DARK_GREEN);
                        string = " (P)";
                    }
                } else {
                    this.setChunkColor(0, Color.black);
                }
                String string2 = InsertionLossMetrics.this.formatReadingField() + string;
                return string2;
            }
        };
        this.add((Component)this.addLabel(this.averageLossGain), "2, 0, f, c");
        this.gainDescription = new DynamicLabel(4, this.labelColor, new Font("SansSerif", 0, 12)){

            protected String formatValue(Measurement measurement) {
                InsertionLossMeasurement insertionLossMeasurement = (InsertionLossMeasurement)measurement;
                int n = insertionLossMeasurement.getAverageInsertionLoss();
                if (n > 0) {
                    return "";
                }
                this.setChunkColor(0, Color.black);
                String string = InsertionLossMetrics.this.formatReadingField();
                if (string.startsWith("-")) {
                    string = string.substring(1);
                }
                return "[Gain of " + string + "]";
            }
        };
        this.add((Component)this.addLabel(this.gainDescription), "0, 1, f, c");
    }

    private DynamicLabel addLabel(DynamicLabel dynamicLabel) {
        this.getLabels().addElement(dynamicLabel);
        return dynamicLabel;
    }

    public Vector getLabels() {
        return this.labels;
    }

    public void setReadingFields(ReadingField[] readingFieldArray) {
        this.readingFields = readingFieldArray;
    }

    public ReadingField[] getReadingFields() {
        return this.readingFields;
    }

    public void setMeasurement(Measurement measurement) {
        DynamicLabel.updateLabelsForMeasurement(this.getLabels(), measurement);
    }

    private String formatReadingField() {
        return this.getReadingFields()[0].getValue() + " " + this.getReadingFields()[0].getUnits();
    }
}

