/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.twoPortInsertionLoss;

import elgato.infrastructure.analyzer.AntennaTraceAnalyzer;
import elgato.infrastructure.analyzer.AntennaTraceChart;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.analyzer.TwoPortLossTraceChart;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.marker.MarkerListener;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.readings.IntegerReadingField;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.measurement.twoPortInsertionLoss.InsertionLossMetrics;
import elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossMeasurement;
import elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossMeasurementSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TwoPortInsertionLossAnalyzer
extends AntennaTraceAnalyzer {
    private TwoPortInsertionLossMeasurement measurement;
    private TwoPortInsertionLossMeasurementSettings settings;
    private InsertionLossMetrics metrics;
    private final NumberFieldStrategy decibelStrategyTraceSave = new DecibelStrategy(1, false);
    private final NumberFieldStrategy freqStrategyTraceSave = new NumberFieldStrategy("Hz");
    private AntennaTraceAnalyzer.XStartListener xStartListener;
    private AntennaTraceAnalyzer.XStopListener xStopListener;

    public TwoPortInsertionLossAnalyzer() {
        super(TwoPortInsertionLossMeasurementSettings.instance().getRefLevel(), TwoPortInsertionLossMeasurementSettings.instance().getScaleDiv(), "2PortInsLossAn");
        this.settings = TwoPortInsertionLossMeasurementSettings.instance();
        this.metrics = new InsertionLossMetrics();
        this.xStartListener = new AntennaTraceAnalyzer.XStartListener(this);
        this.xStopListener = new AntennaTraceAnalyzer.XStopListener(this);
        this.markerModeListener = new MarkerListener(){

            public void markerUpdated() {
                if (TwoPortInsertionLossAnalyzer.this.topPanel != null && TwoPortInsertionLossAnalyzer.this.markerLabel != null) {
                    TwoPortInsertionLossAnalyzer.this.topPanel.remove(TwoPortInsertionLossAnalyzer.this.markerLabel);
                    TwoPortInsertionLossAnalyzer.this.topPanel.add((Component)TwoPortInsertionLossAnalyzer.this.markerLabel, "East");
                    TwoPortInsertionLossAnalyzer.this.topPanel.validate();
                }
            }
        };
        this.settings.getStartFrequency().addValueListener(this.xStartListener);
        this.settings.getStopFrequency().addValueListener(this.xStopListener);
        this.settings.getLimitsToggle().addValueListener(this.limitsStateListener);
        TraceChart traceChart = this.getChart();
        traceChart.setManualXRange(false);
        this.init();
        this.settings.getLimitsToggle().fireValueChanged();
    }

    public void dispose() {
        this.settings.getStartFrequency().removeValueListener(this.xStartListener);
        this.settings.getStopFrequency().removeValueListener(this.xStopListener);
        this.settings.getLimitsToggle().removeValueListener(this.limitsStateListener);
        this.xStartListener = null;
        this.xStopListener = null;
        super.dispose();
    }

    protected AntennaTraceChart getLineChart() {
        return new TwoPortLossTraceChart();
    }

    protected String getUncalibratedText() {
        return Text.UnNormalized;
    }

    protected String getCalibratedText() {
        return Text.Normalized;
    }

    protected TraceAnalyzer.AverageDynamicLabel getAverageDynamicLabel() {
        return new TraceAnalyzer.AverageDynamicLabel(TwoPortInsertionLossMeasurement.AVERAGE_TYPE, TwoPortInsertionLossMeasurement.NUM_AVERAGES, TwoPortInsertionLossMeasurement.AVERAGE_COUNT);
    }

    protected Component createBottomPanel() {
        return new BorderWrapper(this.metrics, MeasurementMetrics.BORDER, true);
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    protected void setMeasurement(Measurement measurement) {
        TraceChart traceChart;
        if (this.measurement != null) {
            this.measurement.recycle();
        }
        if ((traceChart = this.getChart()).isManualXRange()) {
            traceChart.setManualXRange(false);
        }
        this.measurement = (TwoPortInsertionLossMeasurement)measurement;
        this.metrics.setReadingFields(this.createMyReadingFields());
    }

    public MeasurementMetrics getMeasurementMetrics() {
        return this.metrics;
    }

    public TabDelimitable[] createReadingFields() {
        TabDelimitable[] tabDelimitableArray;
        TwoPortInsertionLossMeasurement twoPortInsertionLossMeasurement = (TwoPortInsertionLossMeasurement)this.getMeasurement();
        int n = twoPortInsertionLossMeasurement.getTrace().length;
        int n2 = 0;
        int n3 = 0;
        ReadingField[] readingFieldArray = this.createMyReadingFields();
        int n4 = readingFieldArray.length;
        if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() == 1) {
            n2 = 3;
            tabDelimitableArray = new TabDelimitable[n4 + n + n2];
            for (int i = 0; i < n4; ++i) {
                tabDelimitableArray[n3++] = readingFieldArray[i];
            }
            tabDelimitableArray[n3++] = new TraceSaveTabDelimitable("");
            tabDelimitableArray[n3++] = new TraceSaveTabDelimitable("Trace Data");
            tabDelimitableArray[n3++] = new TraceSaveTabDelimitable("X-AXIS\t\tY-AXIS");
            TraceSaveTabDelimitable.fillTabDelimitables(twoPortInsertionLossMeasurement, "Trace", this.freqStrategyTraceSave, 1, this.decibelStrategyTraceSave, tabDelimitableArray, n3);
        } else {
            tabDelimitableArray = new TabDelimitable[n4];
            for (int i = 0; i < n4; ++i) {
                tabDelimitableArray[n3++] = readingFieldArray[i];
            }
        }
        return tabDelimitableArray;
    }

    private ReadingField[] createMyReadingFields() {
        return new ReadingField[]{new IntegerReadingField(this, "Average Insertion Loss", "dB", TwoPortInsertionLossMeasurement.AVERAGE_INSERTION_LOSS, 1000.0, 2)};
    }

    protected boolean isValidCalibration(Measurement measurement) {
        return ((TwoPortInsertionLossMeasurement)measurement).isValidCalibration();
    }

    protected long getSettingsXstart() {
        return TwoPortInsertionLossMeasurementSettings.instance().getStartFrequency().longValue();
    }

    protected long getSettingsXstop() {
        return TwoPortInsertionLossMeasurementSettings.instance().getStopFrequency().longValue();
    }

    protected JComponent makeTopPanel() {
        this.topPanel = new JPanel(new BorderLayout());
        this.topPanel.setBackground(null);
        this.topPanel.add((Component)this.addLabel(this.calibrationLabel), "West");
        this.topPanel.add((Component)this.addLabel(this.markerLabel), "East");
        return this.topPanel;
    }

    protected void setLimitsState() {
        AntennaTraceChart antennaTraceChart = (AntennaTraceChart)this.getOurChart();
        antennaTraceChart.setShowLimits(this.settings.getLimitsToggle().booleanValue());
    }
}

