/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.twoPortInsertionLoss;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.calibration.AbstractCalibrateScreen;
import elgato.infrastructure.calibration.CalibrateCommand;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.mainScreens.DefaultProgressIndicator;
import elgato.infrastructure.mainScreens.FixedPanel;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.BorderedProgressIndicator;
import elgato.infrastructure.widgets.ProgressIndicator;
import elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossCalibrateScreen;
import elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossMeasurementSettings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TwoPortInsertionLossCalibrateScreen
extends AbstractCalibrateScreen {
    private static final String MEASUREMENT_NAME = Text.Two_Port_Loss;
    private static final int CALIBRATE_INSERTION_LOSS = 8;
    private static final int MEASURE_INSERTION_LOSS_NORMALIZED = 10;
    private Component[] calibratePanels;
    private Component[] waitPanels;
    private int currentStep;
    private Menu firstRightMenu;
    private ProgressIndicator progressIndicator;
    private MenuItem continueButton;
    private MenuItem cancelButton;
    private LongActuator _mode = TwoPortInsertionLossMeasurementSettings.instance().getMode();
    private int _startMode = this._mode.intValue();
    static /* synthetic */ Class class$elgato$measurement$twoPortInsertionLoss$TwoPortInsertionLossMeasurement;

    public TwoPortInsertionLossCalibrateScreen(MeasurementListener measurementListener) {
        super("antInsLoss", class$elgato$measurement$twoPortInsertionLoss$TwoPortInsertionLossMeasurement == null ? (class$elgato$measurement$twoPortInsertionLoss$TwoPortInsertionLossMeasurement = TwoPortInsertionLossCalibrateScreen.class$("elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossMeasurement")) : class$elgato$measurement$twoPortInsertionLoss$TwoPortInsertionLossMeasurement, 10, measurementListener);
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        screenManager.installLeftMenu(new Menu(MEASUREMENT_NAME, new MenuItem[0]));
        this.continueButton = this.createContinueButton(screenManager);
        this.cancelButton = this.createCancelButton(screenManager);
        this.continueButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.firstRightMenu = new Menu(Text.Normalize, new MenuItem[]{this.continueButton, null, null, null, null, null, this.cancelButton});
        this.currentStep = 0;
        this.configureWizard();
        this.pauseMeasurement();
        MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(new CommandListener(){

            public void commandReceived(Command command) {
                if (command.getProperty("event").equals("ilCalStarted")) {
                    TwoPortInsertionLossCalibrateScreen.this.continueButton.setEnabled(true);
                    TwoPortInsertionLossCalibrateScreen.this.cancelButton.setEnabled(true);
                }
            }
        });
        this.setMode(8);
        this.displayCurrentPanel(screenManager);
    }

    public void uninstallScreen(ScreenManager screenManager) {
        this.stopProgressTimer();
        this.registerGlobalKeyManagerAsKeyListener(screenManager);
        MeasurementFactory.instance().getCommandProcessor().sendResumeCommand();
        MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(this.savedMeasurementListener, this.measurementClass);
        super.uninstallScreen(screenManager);
    }

    private void configureWizard() {
        this.calibratePanels = new Component[1];
        this.waitPanels = new Component[1];
        this.calibratePanels[0] = this.installFirstPanel();
        this.waitPanels[0] = this.createWaitPanel();
    }

    MenuItem createCancelButton(final ScreenManager screenManager) {
        return new PushButton(Text.Cancel, "help", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TwoPortInsertionLossCalibrateScreen.this._mode.setValue(TwoPortInsertionLossCalibrateScreen.this._startMode);
                screenManager.popScreen();
            }
        });
    }

    private void displayCurrentPanel(ScreenManager screenManager) {
        this.installRightMenu(screenManager);
        screenManager.installDisplay(this.calibratePanels[this.currentStep]);
    }

    private Component createWaitPanel() {
        String[] stringArray = new String[]{Text.SCREEN_INSERTION_LOSS_CALIBRATE_STANDBY_TITLE, " ", Text.SCREEN_INSERTION_LOSS_CALIBRATION_WAIT_INSTRUCTIONS2, Text.SCREEN_INSERTION_LOSS_CALIBRATION_WAIT_INSTRUCTIONS3, Text.SCREEN_INSERTION_LOSS_CALIBRATION_WAIT_INSTRUCTIONS4, Text.SCREEN_INSERTION_LOSS_CALIBRATION_WAIT_INSTRUCTIONS5, Text.SCREEN_INSERTION_LOSS_CALIBRATION_WAIT_INSTRUCTIONS6, Text.SCREEN_INSERTION_LOSS_CALIBRATION_WAIT_INSTRUCTIONS7, " "};
        this.progressIndicator = new BorderedProgressIndicator(new DefaultProgressIndicator(stringArray));
        return (Component)((Object)this.progressIndicator);
    }

    private void stopProgressTimer() {
        this.progressIndicator.stop();
    }

    private void installRightMenu(ScreenManager screenManager) {
        screenManager.installRightMenu(this.firstRightMenu);
    }

    void pauseMeasurement() {
        MeasurementFactory.instance().getCommandProcessor().sendPauseCommand();
    }

    protected MenuItem getCancelButton() {
        return this.cancelButton;
    }

    MenuItem createContinueButton(final ScreenManager screenManager) {
        final Class clazz = class$elgato$measurement$twoPortInsertionLoss$TwoPortInsertionLossMeasurement == null ? (class$elgato$measurement$twoPortInsertionLoss$TwoPortInsertionLossMeasurement = TwoPortInsertionLossCalibrateScreen.class$("elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossMeasurement")) : class$elgato$measurement$twoPortInsertionLoss$TwoPortInsertionLossMeasurement;
        return new PushButton(Text.Continue, this.getContextString("continue"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                screenManager.clearRightMenu();
                screenManager.installDisplay(TwoPortInsertionLossCalibrateScreen.this.waitPanels[TwoPortInsertionLossCalibrateScreen.this.currentStep]);
                MeasurementListener measurementListener = new MeasurementListener(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void measurementReceived(Measurement measurement) {
                        MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(new CommandListener(this){
                            private final /* synthetic */ 4 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void commandReceived(Command command) {
                                if (command.getProperty("event").equals("ilCalComplete")) {
                                    TwoPortInsertionLossCalibrateScreen.access$800(3.access$700(4.access$600(this.this$2)));
                                    TwoPortInsertionLossCalibrateScreen.access$900(3.access$700(4.access$600(this.this$2)));
                                }
                            }
                        });
                        MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(new CommandListener(this){
                            private final /* synthetic */ 4 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void commandReceived(Command command) {
                                if (command.getProperty("errCmd").equals("single")) {
                                    TwoPortInsertionLossCalibrateScreen.access$800(3.access$700(4.access$600(this.this$2)));
                                    CalibrateCommand.popScreenAndShowNormalizeErrorMessage(3.access$1000(4.access$600(this.this$2)));
                                }
                            }
                        });
                        TwoPortInsertionLossCalibrateScreen.access$300(3.access$700(this.this$1)).send(10L);
                        MeasurementFactory.instance().getMeasurementReader().removeMeasurementListener(this, 3.access$1100(this.this$1));
                    }

                    static /* synthetic */ 3 access$600(4 var0) {
                        return var0.this$1;
                    }
                };
                MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(measurementListener, clazz);
                MeasurementFactory.instance().getCommandProcessor().sendSingleCommand();
                TwoPortInsertionLossCalibrateScreen.this.currentStep++;
            }

            static /* synthetic */ TwoPortInsertionLossCalibrateScreen access$700(3 var0) {
                return var0.TwoPortInsertionLossCalibrateScreen.this;
            }

            static /* synthetic */ ScreenManager access$1000(3 var0) {
                return var0.screenManager;
            }

            static /* synthetic */ Class access$1100(3 var0) {
                return var0.clazz;
            }
        });
    }

    private void doPopScreen() {
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                ScreenManager screenManager = TwoPortInsertionLossCalibrateScreen.this.getScreenManager();
                if (screenManager != null) {
                    screenManager.popScreen();
                    TwoPortInsertionLossCalibrateScreen.this.doOtherStuff(screenManager);
                } else {
                    TwoPortInsertionLossCalibrateScreen.access$1200().error("Screen doesn't have a screenManager!");
                }
            }
        }, "InsertionLossScreen.doPopScreen");
    }

    protected void doOtherStuff(ScreenManager screenManager) {
    }

    private void cleanListenersUpAfterCalibration() {
        MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
        MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(null);
    }

    protected Component installFirstPanel() {
        FixedPanel fixedPanel = new FixedPanel("images/insertion_loss_cal.png", false);
        fixedPanel.addCenteredLabel(30, Text.SCREEN_CALIBRATE_CONNECT_JUMPER);
        fixedPanel.addLabel(65, 130, Text.RF_IN);
        fixedPanel.addLabel(370, 120, Text.RF_OUT);
        fixedPanel.addLabel(370, 140, Text.slash_SWR);
        fixedPanel.addLabel(135, 190, Text.Jumper_Cable);
        fixedPanel.addLabel(245, 220, Text.ten_dB_Pad);
        fixedPanel.addLabel(360, 220, Text.ten_dB_Pad);
        fixedPanel.addLabel(25, 300, Text.SCREEN_INSERTION_LOSS_CALIBRATION_INSTRUCTIONS1);
        fixedPanel.addLabel(25, 320, Text.SCREEN_INSERTION_LOSS_CALIBRATION_INSTRUCTIONS2);
        return AbstractCalibrateScreen.wrapWithCalibrateBorder(fixedPanel);
    }

    public void setContinueButtonText(String string) {
        this.continueButton.setText(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$800(TwoPortInsertionLossCalibrateScreen twoPortInsertionLossCalibrateScreen) {
        twoPortInsertionLossCalibrateScreen.cleanListenersUpAfterCalibration();
    }

    static /* synthetic */ void access$900(TwoPortInsertionLossCalibrateScreen twoPortInsertionLossCalibrateScreen) {
        twoPortInsertionLossCalibrateScreen.doPopScreen();
    }

    static /* synthetic */ Logger access$1200() {
        return AbstractCalibrateScreen.logger;
    }
}

