/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.twoPortInsertionLoss;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.measurement.twoPortInsertionLoss.InsertionLossMeasurementSettings;

public class TwoPortInsertionLossMeasurementSettings
extends InsertionLossMeasurementSettings {
    public static final String TOPIC_TWO_PORT_INSERTIONLOSS = "antInsLoss";
    public static final String TOPIC_TWO_PORT_INSERTIONLOSS_DISPLAY = "display.antInsLoss";
    static final String COMMAND_PROCESSOR_KEY_SRCLVL = "srcAmp";
    static final String COMMAND_PROCESSOR_KEY_SRCLVL_AUTO = "autoSrcAmp";
    private static final int MAX_SRC_AMP = 150000;
    private static final int MIN_SRC_AMP_FOR_TWO_PORT = -100000;
    protected static InsertionLossMeasurementSettings instance;

    private TwoPortInsertionLossMeasurementSettings() {
        super(TOPIC_TWO_PORT_INSERTIONLOSS);
    }

    public static TwoPortInsertionLossMeasurementSettings instance() {
        if (instance == null) {
            instance = new TwoPortInsertionLossMeasurementSettings();
            MeasurementSettings.logger.instanceTrack(instance, "create");
        }
        return (TwoPortInsertionLossMeasurementSettings)instance;
    }

    public String getTopic() {
        return TOPIC_TWO_PORT_INSERTIONLOSS;
    }

    public LongActuator getRefLevel() {
        return this.refLevel;
    }

    public LongActuator getSourceLevel() {
        return this.sourceLevel;
    }

    public ValueInterface getStashedManualValue() {
        return this.stashedManualValue;
    }

    public ListActuator getSourceLevelAutoManual() {
        return this.sourceLevelAutoManual;
    }

    public ListActuator getOptMode() {
        return this.optMode;
    }

    protected void addAdditionalActuators() {
        super.addAdditionalActuators();
        this.sourceLevelAutoManual = new InsertionLossMeasurementSettings.RestrictedListActuator(TOPIC_TWO_PORT_INSERTIONLOSS, COMMAND_PROCESSOR_KEY_SRCLVL_AUTO, Text.Source_Lev, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
        this.sourceLevel = new LongActuator(TOPIC_TWO_PORT_INSERTIONLOSS, COMMAND_PROCESSOR_KEY_SRCLVL, Text.Source_Lev, new FactorConversion("dBm", 1000L));
        this.stashedManualValue = new LongActuator(TOPIC_TWO_PORT_INSERTIONLOSS_DISPLAY, "stashedSourceLevel", "", new FactorConversion("dBm", 1000L));
        this.configureSourceLevel(this.sourceLevel);
        this.configureSourceLevel(this.stashedManualValue);
        this.makeStashedActuatorSet(this.sourceLevelAutoManual, this.sourceLevel, this.stashedManualValue, 0, "2-PortInsLoss.sourceLevel");
        this.optMode = new ListActuator(TOPIC_TWO_PORT_INSERTIONLOSS, "optMode", Text.Optimize, new Value[]{Value.createValue(Text.Accy, 0), Value.createValue(Text.Range, 1)});
        this.refLevel = LongActuator.createRefLevelActuator(this.DISPLAY_TOPIC, 0, "dB", -100000, 150000, this.getScaleDiv());
        if (!MeasurementFactory.instance().measurementAvailable("source")) {
            this.sourceLevelAutoManual.onlyAllowAuto = true;
        }
        this.add(this.refLevel);
        this.add(this.sourceLevel);
        this.add(this.sourceLevelAutoManual);
        this.add(this.stashedManualValue);
        this.add(this.optMode);
    }

    private void configureSourceLevel(LongActuator longActuator) {
        longActuator.setIncrement(1000);
        longActuator.setValidator(new RangeValidator(-100000L, 10000L, 2));
        longActuator.setPalette(Palette.createSignedDecimal());
    }

    public static void clearInstance() {
        if (instance != null) {
            MeasurementSettings.logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }
}

