/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.actuators.CenterFrequencyActuator;
import elgato.infrastructure.actuators.FreqChanActuatorConfigurator;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.ScaleDivActuator;
import elgato.infrastructure.analyzer.SpectralChart;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.util.Vector;

public class CommonUMTSMeasurementSettings
extends MeasurementSettings {
    protected final String TOPIC = this.getTopic();
    protected final String DISPLAY_TOPIC = "display." + this.TOPIC;
    public static final int VIEWMODE_ZOOM = 0;
    public static final int VIEWMODE_FULL = 1;
    public static final int REF_REL = 0;
    public static final int REF_ABS = 1;
    public static final int EQ_OFF = 0;
    public static final int EQ_RUN = 1;
    public static final int EQ_HOLD = 2;
    public static final int CHANTYPE_NOISE = 0;
    public static final int CHANTYPE_CPICH = 1;
    public static final int CHANTYPE_PCCPCH = 2;
    public static final int CHANTYPE_SCCPCH = 3;
    public static final int CHANTYPE_PICH = 4;
    public static final int CHANTYPE_DPCH_TRAFFIC = 5;
    public static final int CHANTYPE_HSSCCH = 6;
    public static final int CHANTYPE_HSPDSCH_TRAFFIC = 7;
    public static final int CHANTYPE_HSPDSCH_QAM_TRAFFIC = 8;
    public static final int CHANTYPE_UNKNOWN = 9;
    public static final int EVM_MODE_COMP = 0;
    public static final int EVM_MODE_PILOT = 1;
    private static final String KEY_FREQ_ERROR_LOW_LIMIT = "freqErrorLowerLimit";
    private static final String KEY_FREQ_ERROR_LOW_LIMIT_MODE = "freqErrorLowerLimitMode";
    private static final String KEY_FREQ_ERROR_UP_LIMIT = "freqErrorUpperLimit";
    private static final String KEY_EVM_UP_LIMIT_QPSK = "evmUpperLimit1";
    private static final String KEY_EVM_UP_LIMIT_16QAM = "evmUpperLimit2";
    private static final String KEY_PCDE_UP_LIMIT = "pcdeUpperLimit";
    private static final String KEY_CPICH_LOW_LIMIT = "cpichLowerLimit";
    private static final String KEY_CPICH_UP_LIMIT = "cpichUpperLimit";
    private boolean doingLimitSetAll = true;
    private boolean bLimitsSummaryState = false;
    public static final int WCDMA_LIMIT_SIZE = 4;
    public static final int LIMIT_FREQ_ERROR = 0;
    public static final int LIMIT_EVM = 1;
    public static final int LIMIT_PCDE = 2;
    public static final int LIMIT_CPICH = 3;
    private final ListActuator viewMode = new ListActuator(this.DISPLAY_TOPIC, "viewMode", Text.View, new Value[]{Value.createValue(Text.Zoom, 0), Value.createValue(Text.Full, 1)});
    private final LongActuator position = new LongActuator(this.DISPLAY_TOPIC, "position", Text.Position);
    private final ListActuator width = new ListActuator(this.DISPLAY_TOPIC, "width", Text.Width, new Value[]{Value.createValue("32", 32), Value.createValue("64", 64), Value.createValue("128", 128), Value.createValue("256", 256)});
    private final ListActuator sccpchEnabled = this.makeBooleanActuator("sccpchEnabled", Text.S_CCPCH_n_Enable);
    private final ListActuator pichEnabled = this.makeBooleanActuator("pichEnabled", Text.PICH_n_Enable);
    private final ListActuator metricsEnabled = this.makeBooleanActuator("metricsEnabled", Text.Metrics);
    private final ListActuator sccpchSpreadFactor = new ListActuator(this.TOPIC, "sccpchSf", Text.Spread_n_Factor, new Value[]{Value.createValue("4", 4), Value.createValue("8", 8), Value.createValue("16", 16), Value.createValue("32", 32), Value.createValue("64", 64), Value.createValue("128", 128), Value.createValue("256", 256)});
    private final LongActuator sccpchLocation = new LongActuator(this.TOPIC, "sccpchCh", Text.Channel);
    private final LongActuator pichLocation = new LongActuator(this.TOPIC, "pichCh", Text.Channel);
    private final ListActuator reference = new ListActuator(this.DISPLAY_TOPIC, "reference", Text.Ref_Level, new Value[]{Value.createValue(Text.Abs, 1), Value.createValue(Text.Rel, 0)});
    private final FrequencyActuator centerFreq = CenterFrequencyActuator.createCenterFrequencyActuator(this.TOPIC, "cf");
    private final LongActuator scramblingCode = new LongActuator(this.TOPIC, "sc", Text.Scramble_Code);
    private final ListActuator scramblingCodeAuto = new ListActuator(this.TOPIC, "scAuto", Text.Scramble_Code, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
    private final ListActuator speedOfTheMeasurement = new ListActuator(this.TOPIC, "measSpeed", Text.Meas_Time, new Value[]{Value.createValue(Text.Slow, 2), Value.createValue(Text.Med, 1), Value.createValue(Text.Fast, 0)});
    private final ListActuator evmMode = new ListActuator(this.TOPIC, "evmMode", Text.EVM_Mode, new Value[]{Value.createValue(Text.EVM_Comp, 0), Value.createValue(Text.EVM_Pilot, 1)});
    private final ListActuator eqStatus = new ListActuator(this.TOPIC, "ifEqStatus", Text.EQ_Status, new Value[]{Value.createValue(Text.EQ_Off, 0), Value.createValue(Text.EQ_Run, 1), Value.createValue(Text.EQ_Hold, 2)});
    private final LongActuator thresholdOffset = LongActuator.createPower(this.TOPIC, "threshOffset", Text.Auto_Thres_n_Offset, new RangeValidator(-20000L, 20000L, 2));
    private final LongActuator thresholdLevel = LongActuator.createPower(this.TOPIC, "threshLv", Text.Threshold, new RangeValidator(-45000L, 0L, 2));
    private final ListActuator thresholdAuto = new ListActuator(this.TOPIC, "threshAuto", Text.Threshold, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
    private final LongActuator rfInLoss = LongActuator.createLoss(this.TOPIC, "atten", Text.RF_IN_Loss, 0);
    private final ListActuator averaging = ListActuator.createAveragingOffOn(this.TOPIC);
    private final LongActuator numAverages = LongActuator.createNumAverages(this.TOPIC, 100);
    private final ScaleDivActuator scaleDiv = new ScaleDivActuator(this.DISPLAY_TOPIC, 5000);
    private ListActuator codogramEnabled = new ListActuator(this.DISPLAY_TOPIC, "codogramEnabled", Text.Codogram, this.createOnOffValueSet());
    private ListActuator codogramPalette = new ListActuator(this.DISPLAY_TOPIC, "codogramPalette", Text.Palette, SpectralChart.createPaletteValues());
    private final LongActuator codogramCaptureInterval = new LongActuator(this.DISPLAY_TOPIC, "codogramCaptureInterval", Text.Update_n_Interval);
    private ListActuator activeCodeChTableEnabled = new ListActuator(this.DISPLAY_TOPIC, "activeCodeChTableEnabled", Text.Active_Code_n_Ch_Table, this.createOnOffValueSet());
    private int originalMetrics;
    private Vector limitsToggles = new Vector();
    private FrequencyActuator freqErrorLowerLimit = new FrequencyActuator(this.DISPLAY_TOPIC, "freqErrorLowerLimit", Text.Low_Limit);
    private final ListActuator freqErrorLowerLimitMode = new ListActuator(this.DISPLAY_TOPIC, "freqErrorLowerLimitMode", Text.Low_Limit, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
    private FrequencyActuator freqErrorUpperLimit = new FrequencyActuator(this.DISPLAY_TOPIC, "freqErrorUpperLimit", Text.High_Limit);
    private LongActuator evmUpperLimit1 = LongActuator.createDecimal(this.DISPLAY_TOPIC, "evmUpperLimit1", Text.High_Limit_n_leftBanana_QPSK_only_rightBanana, "%", 1000);
    private LongActuator evmUpperLimit2 = LongActuator.createDecimal(this.DISPLAY_TOPIC, "evmUpperLimit2", Text.High_Limit_n_leftBanana_incl_16QAM_rightBanana, "%", 1000);
    private LongActuator pcdeUpperLimit = LongActuator.createDecimal(this.DISPLAY_TOPIC, "pcdeUpperLimit", Text.High_Limit, "dB", 1000);
    private LongActuator cpichLowerLimit = LongActuator.createDecimal(this.DISPLAY_TOPIC, "cpichLowerLimit", Text.Low_Limit, "dB", 1000);
    private LongActuator cpichUpperLimit = LongActuator.createDecimal(this.DISPLAY_TOPIC, "cpichUpperLimit", Text.High_Limit, "dB", 1000);
    private final ListActuator hsdpa = this.makeBooleanActuator("hsdpa", Text.HSDPA);
    private int iActiveCodeChTableEnabledState;

    public CommonUMTSMeasurementSettings(final String string) {
        super(string);
        this.add(this.viewMode);
        this.add(this.width);
        this.add(this.position);
        this.add(this.sccpchEnabled);
        this.add(this.pichEnabled);
        this.add(this.sccpchLocation);
        this.add(this.pichLocation);
        this.add(this.reference);
        this.add(this.centerFreq);
        this.add(this.scramblingCode);
        this.add(this.scramblingCodeAuto);
        this.add(this.speedOfTheMeasurement);
        this.add(this.thresholdOffset);
        this.add(this.thresholdLevel);
        this.add(this.thresholdAuto);
        this.add(this.rfInLoss);
        this.add(this.averaging);
        this.add(this.numAverages);
        this.add(this.sccpchSpreadFactor);
        this.add(this.codogramEnabled);
        this.add(this.codogramPalette);
        this.add(this.codogramCaptureInterval);
        this.add(this.activeCodeChTableEnabled);
        this.add(this.metricsEnabled);
        this.add(this.scaleDiv);
        this.add(this.hsdpa);
        this.add(this.evmMode);
        this.add(this.eqStatus);
        this.add(this.freqErrorLowerLimitMode);
        this.add(this.freqErrorLowerLimit);
        this.add(this.freqErrorUpperLimit);
        this.add(this.evmUpperLimit1);
        this.add(this.evmUpperLimit2);
        this.add(this.pcdeUpperLimit);
        this.add(this.cpichLowerLimit);
        this.add(this.cpichUpperLimit);
        this.setValidatorToFreqCalLimits(this.centerFreq);
        this.makeStashedLossActuatorSet(DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.rfInLoss, DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), string + ".RfInLossListener");
        this.reference.setValue(0);
        this.position.setValidator(new RangeValidator(0L, 511L));
        this.position.setIncrement(5);
        this.width.setValue(128);
        ValueListener valueListener = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = string + ".positionLimiterListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                int n = 512 - CommonUMTSMeasurementSettings.this.width.intValue();
                if (CommonUMTSMeasurementSettings.this.position.intValue() > n) {
                    CommonUMTSMeasurementSettings.this.position.send(n);
                } else {
                    CommonUMTSMeasurementSettings.this.position.send(CommonUMTSMeasurementSettings.this.position.intValue());
                }
            }
        };
        this.position.addValueListener(valueListener);
        this.width.addValueListener(valueListener);
        ValueListener valueListener2 = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = string + ".codogramListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                boolean bl = valueInterface.booleanValue();
                if (bl) {
                    CommonUMTSMeasurementSettings.this.iActiveCodeChTableEnabledState = CommonUMTSMeasurementSettings.this.activeCodeChTableEnabled.intValue();
                    CommonUMTSMeasurementSettings.this.originalMetrics = CommonUMTSMeasurementSettings.this.metricsEnabled.intValue();
                    CommonUMTSMeasurementSettings.this.activeCodeChTableEnabled.send(0);
                    CommonUMTSMeasurementSettings.this.setMetricsEnabled(0);
                } else {
                    CommonUMTSMeasurementSettings.this.activeCodeChTableEnabled.send(CommonUMTSMeasurementSettings.this.iActiveCodeChTableEnabledState);
                    CommonUMTSMeasurementSettings.this.setMetricsEnabled(CommonUMTSMeasurementSettings.this.originalMetrics);
                }
            }
        };
        this.originalMetrics = 1;
        this.metricsEnabled.setValue(this.originalMetrics);
        this.codogramEnabled.setValue(0);
        this.codogramEnabled.addValueListener(valueListener2);
        RangeValidator rangeValidator = new RangeValidator(0L, Integer.MAX_VALUE);
        this.codogramCaptureInterval.setUnitsFactory(new MeasurementSettings.UpdateIntervalUnitSystem());
        this.codogramCaptureInterval.setValidator(rangeValidator);
        ValueListener valueListener3 = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = string + ".codogramListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                boolean bl = valueInterface.booleanValue();
                if (bl && CommonUMTSMeasurementSettings.this.codogramEnabled.booleanValue()) {
                    CommonUMTSMeasurementSettings.this.iActiveCodeChTableEnabledState = valueInterface.intValue();
                    CommonUMTSMeasurementSettings.this.codogramEnabled.send(0);
                }
            }
        };
        this.activeCodeChTableEnabled.setValue(0);
        this.activeCodeChTableEnabled.addValueListener(valueListener3);
        this.sccpchSpreadFactor.setLongLabel(Text.S_CCPCH_Spread_Factor);
        this.sccpchLocation.setLongLabel(Text.S_CCPCH_Channel);
        this.pichLocation.setLongLabel(Text.PICH_Channel);
        this.sccpchSpreadFactor.addValueListener(new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = string + ".sccpchSfListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                CommonUMTSMeasurementSettings.this.sccpchLocation.setValidator(new RangeValidator(0L, CommonUMTSMeasurementSettings.this.sccpchSpreadFactor.intValue() - 1));
            }
        });
        this.pichLocation.setValidator(new RangeValidator(0L, 255L));
        this.sccpchLocation.setValue(6);
        this.pichLocation.setValue(32);
        this.scramblingCode.setValidator(new RangeValidator(0L, 511L));
        this.freqErrorLowerLimit.addValueListener(new WcdmaValueListener(KEY_FREQ_ERROR_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonUMTSMeasurementSettings.this.doingLimitSetAll) {
                    CommonUMTSMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.freqErrorUpperLimit.addValueListener(new WcdmaValueListener(KEY_FREQ_ERROR_UP_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (CommonUMTSMeasurementSettings.this.freqErrorLowerLimitMode.booleanValue()) {
                    CommonUMTSMeasurementSettings.this.freqErrorLowerLimit.send(0 - valueInterface.intValue());
                }
                if (!CommonUMTSMeasurementSettings.this.doingLimitSetAll) {
                    CommonUMTSMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.freqErrorLowerLimitMode.addValueListener(new WcdmaValueListener(KEY_FREQ_ERROR_LOW_LIMIT_MODE){

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.booleanValue()) {
                    CommonUMTSMeasurementSettings.this.freqErrorLowerLimit.send(0 - CommonUMTSMeasurementSettings.this.freqErrorUpperLimit.intValue());
                }
                if (!CommonUMTSMeasurementSettings.this.doingLimitSetAll) {
                    CommonUMTSMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.evmUpperLimit1.addValueListener(new WcdmaValueListener(KEY_EVM_UP_LIMIT_QPSK){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonUMTSMeasurementSettings.this.doingLimitSetAll) {
                    CommonUMTSMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.evmUpperLimit2.addValueListener(new WcdmaValueListener(KEY_EVM_UP_LIMIT_16QAM){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonUMTSMeasurementSettings.this.doingLimitSetAll) {
                    CommonUMTSMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.pcdeUpperLimit.addValueListener(new WcdmaValueListener(KEY_PCDE_UP_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonUMTSMeasurementSettings.this.doingLimitSetAll) {
                    CommonUMTSMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.cpichUpperLimit.addValueListener(new WcdmaValueListener(KEY_CPICH_UP_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonUMTSMeasurementSettings.this.doingLimitSetAll) {
                    CommonUMTSMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.cpichLowerLimit.addValueListener(new WcdmaValueListener(KEY_CPICH_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonUMTSMeasurementSettings.this.doingLimitSetAll) {
                    CommonUMTSMeasurementSettings.this.setAllLimits();
                }
            }
        });
        DisplayGlobalMeasurementSettings displayGlobalMeasurementSettings = DisplayGlobalMeasurementSettings.instance();
        new FreqChanActuatorConfigurator(this.centerFreq, displayGlobalMeasurementSettings.getChanFreqUnits(), displayGlobalMeasurementSettings.getChanStd(), displayGlobalMeasurementSettings.getChannelStep(), displayGlobalMeasurementSettings.getFrequencyStep(), BandSelector.getGlobalBandSelector(), string + ".cfListener");
    }

    public LongActuator[] getStorableActuators() {
        return new LongActuator[]{this.freqErrorLowerLimit, this.freqErrorUpperLimit, this.evmUpperLimit1, this.evmUpperLimit2, this.pcdeUpperLimit, this.cpichUpperLimit, this.cpichLowerLimit};
    }

    private ListActuator makeBooleanActuator(String string, String string2) {
        return new ListActuator(this.TOPIC, string, string2, new Value[]{Value.createValue(Text.Off, 0), Value.createValue(Text.On, 1)});
    }

    public ListActuator getViewMode() {
        return this.viewMode;
    }

    public LongActuator getPosition() {
        return this.position;
    }

    public ListActuator getWidth() {
        return this.width;
    }

    public ListActuator getAveraging() {
        return this.averaging;
    }

    public LongActuator getNumAverages() {
        return this.numAverages;
    }

    public ListActuator getSCCPCHEnabled() {
        return this.sccpchEnabled;
    }

    public ListActuator getPICHEnabled() {
        return this.pichEnabled;
    }

    public ListActuator getMetricsEnabled() {
        return this.metricsEnabled;
    }

    public ListActuator getEvmMode() {
        return this.evmMode;
    }

    public ListActuator getEqStatus() {
        return this.eqStatus;
    }

    public void setMetricsEnabled(int n) {
        this.metricsEnabled.setValue(n);
        this.metricsEnabled.send();
    }

    public LongActuator getSCCPCHLocation() {
        return this.sccpchLocation;
    }

    public LongActuator getPICHLocation() {
        return this.pichLocation;
    }

    public ListActuator getReference() {
        return this.reference;
    }

    public boolean isRelative() {
        return this.reference.intValue() == 0;
    }

    public FrequencyActuator getCenterFreq() {
        return this.centerFreq;
    }

    public LongActuator getScramblingCode() {
        return this.scramblingCode;
    }

    public ListActuator getScramblingCodeAuto() {
        return this.scramblingCodeAuto;
    }

    public ListActuator getSpeedOfTheMeasurement() {
        return this.speedOfTheMeasurement;
    }

    public LongActuator getThresholdOffset() {
        return this.thresholdOffset;
    }

    public LongActuator getThresholdLevel() {
        return this.thresholdLevel;
    }

    public ListActuator getThresholdAuto() {
        return this.thresholdAuto;
    }

    public LongActuator getRFInLoss() {
        return this.rfInLoss;
    }

    public ListActuator getSCCPCHSpreadFactor() {
        return this.sccpchSpreadFactor;
    }

    public ListActuator getCodogramEnabled() {
        return this.codogramEnabled;
    }

    public ListActuator getCodogramPalette() {
        return this.codogramPalette;
    }

    public LongActuator getSpectrogramCaptureInterval() {
        return this.codogramCaptureInterval;
    }

    public ListActuator getActiveCodeChTableEnabled() {
        return this.activeCodeChTableEnabled;
    }

    public LongActuator getScaleDiv() {
        return this.scaleDiv;
    }

    public FrequencyActuator getFreqErrorUpperLimit() {
        return this.freqErrorUpperLimit;
    }

    public FrequencyActuator getFreqErrorLowerLimit() {
        return this.freqErrorLowerLimit;
    }

    public ListActuator getFreqErrorLowerLimitMode() {
        return this.freqErrorLowerLimitMode;
    }

    public LongActuator getEvmUpperLimit_QpskOnly() {
        return this.evmUpperLimit1;
    }

    public LongActuator getEvmUpperLimit_inclQam() {
        return this.evmUpperLimit2;
    }

    public LongActuator getPcdeUpperLimit() {
        return this.pcdeUpperLimit;
    }

    public LongActuator getCpichUpperLimit() {
        return this.cpichUpperLimit;
    }

    public LongActuator getCpichLowerLimit() {
        return this.cpichLowerLimit;
    }

    public ListActuator getHsdpa() {
        return this.hsdpa;
    }

    public boolean getLimitsSummaryState() {
        this.bLimitsSummaryState = false;
        for (int i = 0; i < 4; ++i) {
            if (this.limitsToggleAt(i).getSelectedValue().longValue() != 1L) continue;
            this.bLimitsSummaryState = true;
            break;
        }
        return this.bLimitsSummaryState;
    }

    public ListActuator limitsToggleAt(int n) {
        ListActuator listActuator;
        this.limitsToggles.setSize(4);
        try {
            listActuator = (ListActuator)this.limitsToggles.elementAt(n);
            if (listActuator == null) {
                listActuator = new ListActuator(this.DISPLAY_TOPIC, "limitsToggle" + n, Text.Limits, this.createOnOffValueSet());
                listActuator.setValue(0);
                this.add(listActuator);
                listActuator.addValueListener(new WcdmaValueListener("limitsToggle" + n){

                    public void valueChanged(ValueInterface valueInterface) {
                        CommonUMTSMeasurementSettings.this.setAllLimits();
                        CommonUMTSMeasurementSettings.this.bLimitsSummaryState = CommonUMTSMeasurementSettings.this.bLimitsSummaryState && valueInterface.booleanValue();
                    }
                });
                listActuator.setValue(0);
                this.limitsToggles.setElementAt(listActuator, n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            listActuator = null;
        }
        return listActuator;
    }

    public void allowValidationNow() {
        this.doingLimitSetAll = false;
    }

    protected abstract class WcdmaValueListener
    implements ValueListener {
        private final String listenerName;

        public WcdmaValueListener(String string) {
            this.listenerName = CommonUMTSMeasurementSettings.this.DISPLAY_TOPIC + "." + string + ".listener";
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public abstract /* synthetic */ void valueChanged(ValueInterface var1);
    }
}

