/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.analyzer.BarChart;
import elgato.infrastructure.analyzer.BasicBarChartModel;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.util.Text;
import elgato.measurement.umts.CommonUMTSMeasurementSettings;
import elgato.measurement.umts.UMTSMeasurement;
import java.awt.Color;
import java.awt.Image;

class ControlChannelBarChartModel
implements BasicBarChartModel {
    static final Color niceGreen = new Color(0, 220, 0);
    static final Color purple = new Color(170, 0, 192);
    static final Color lightBlue = new Color(140, 160, 255);
    static final Color mediumGray = new Color(96, 96, 96);
    static final Color lightYellow = new Color(255, 255, 153);
    static final Color brown = new Color(153, 51, 0);
    private int actuatorIDBase;
    private Bar[] bars;
    boolean relative = true;
    CommonUMTSMeasurementSettings settings;
    private UMTSMeasurement measurement;

    ControlChannelBarChartModel(int n, CommonUMTSMeasurementSettings commonUMTSMeasurementSettings) {
        this.actuatorIDBase = n;
        this.settings = commonUMTSMeasurementSettings;
        this.bars = this.createBars();
    }

    private Bar[] createBars() {
        return new Bar[]{new CPICHReadingBar(Text.CPICH, Color.red), new FixedTraceLocationCPICHRelativeReadingBar(Text.P_CCPCH, Color.yellow, 12, 1), new ConfigurableTraceLocationCPICHRelativeReadingBarWithVariableSF(Text.S_CCPCH, niceGreen, 13, this.actuatorIDBase + 10, this.actuatorIDBase + 13, this.actuatorIDBase + 12), new ConfigurableTraceLocationCPICHRelativeReadingBarWithFixedSF(Text.PICH, lightBlue, 9, this.actuatorIDBase + 11, this.actuatorIDBase + 14, 256), new CPICHRelativeReadingBar(Text.P_SCH, Color.blue, 10), new CPICHRelativeReadingBar(Text.S_SCH, purple, 11)};
    }

    public int getNumBars() {
        return this.bars.length;
    }

    public int getValue(int n) {
        return this.bars[n].getValue();
    }

    public boolean isActive(int n) {
        Bar bar = this.bars[n];
        return bar.isActive() && bar.isEnabled();
    }

    public Color getColor(int n) {
        Bar bar = this.bars[n];
        return bar.isEnabled() ? bar.color : mediumGray;
    }

    public String getLabel(int n) {
        return this.bars[n].label;
    }

    public Image getBottomOfBarImage(int n) {
        return null;
    }

    public String getValueUnits() {
        return this.settings.isRelative() ? "dB" : "dBm";
    }

    public void setMeasurement(TraceMeasurement traceMeasurement) {
        this.measurement = (UMTSMeasurement)traceMeasurement;
    }

    public Color getColorForChannelType(int n) {
        Color color = null;
        switch (n) {
            case 1: {
                color = Color.red;
                break;
            }
            case 2: {
                color = Color.yellow;
                break;
            }
            case 3: {
                color = niceGreen;
                break;
            }
            case 4: {
                color = lightBlue;
                break;
            }
            case 5: {
                color = Color.orange;
                break;
            }
            case 6: {
                color = Color.pink;
                break;
            }
            case 7: {
                color = lightYellow;
                break;
            }
            case 8: {
                color = brown;
                break;
            }
            case 9: {
                color = BarChart.UNKNOWN_COLOR;
                break;
            }
            default: {
                color = BarChart.NOISE_COLOR;
            }
        }
        return color;
    }

    public Color getColorForChannel(int n, int n2) {
        Bar bar = this.findTraceBar(n, n2);
        if (bar != null) {
            return bar.color;
        }
        return null;
    }

    public String getLabelForChannel(int n) {
        return this.measurement.getLabelForChannel(n);
    }

    private Bar findTraceBar(int n, int n2) {
        for (int i = 0; i < this.bars.length; ++i) {
            TraceBar traceBar;
            Bar bar = this.bars[i];
            if (!(bar instanceof TraceBar) || !(traceBar = (TraceBar)((Object)bar)).matches(n, n2) || !bar.isEnabled()) continue;
            return bar;
        }
        return null;
    }

    private class ConfigurableTraceLocationCPICHRelativeReadingBarWithVariableSF
    extends ConfigurableTraceLocationCPICHRelativeReadingBar {
        private final int sfReadingId;

        public ConfigurableTraceLocationCPICHRelativeReadingBarWithVariableSF(String string, Color color, int n, int n2, int n3, int n4) {
            super(string, color, n, n2, n3);
            this.sfReadingId = n4;
        }

        public int getSpreadFactor() {
            return ControlChannelBarChartModel.this.measurement.getIntegerReadingValue(this.sfReadingId);
        }
    }

    private class ConfigurableTraceLocationCPICHRelativeReadingBarWithFixedSF
    extends ConfigurableTraceLocationCPICHRelativeReadingBar {
        private final int sf;

        public ConfigurableTraceLocationCPICHRelativeReadingBarWithFixedSF(String string, Color color, int n, int n2, int n3, int n4) {
            super(string, color, n, n2, n3);
            this.sf = n4;
        }

        public int getSpreadFactor() {
            return this.sf;
        }
    }

    private abstract class ConfigurableTraceLocationCPICHRelativeReadingBar
    extends CPICHRelativeReadingBar
    implements TraceBar {
        private final int channelActuatorReadingId;
        private final int enabledReadingId;

        public ConfigurableTraceLocationCPICHRelativeReadingBar(String string, Color color, int n, int n2, int n3) {
            super(string, color, n);
            this.channelActuatorReadingId = n2;
            this.enabledReadingId = n3;
        }

        public boolean isEnabled() {
            return ControlChannelBarChartModel.this.measurement.getBooleanReadingValue(this.enabledReadingId);
        }

        public int getChannel() {
            return ControlChannelBarChartModel.this.measurement.getIntegerReadingValue(this.channelActuatorReadingId);
        }

        public boolean matches(int n, int n2) {
            return this.getSpreadFactor() == n && this.getChannel() == n2;
        }

        public abstract /* synthetic */ int getSpreadFactor();
    }

    private class FixedTraceLocationCPICHRelativeReadingBar
    extends CPICHRelativeReadingBar
    implements TraceBar {
        private final int channel;

        public FixedTraceLocationCPICHRelativeReadingBar(String string, Color color, int n, int n2) {
            super(string, color, n);
            this.channel = n2;
        }

        public int getChannel() {
            return this.channel;
        }

        public int getSpreadFactor() {
            return 256;
        }

        public boolean matches(int n, int n2) {
            return this.getSpreadFactor() == n && this.getChannel() == n2;
        }
    }

    private class CPICHRelativeReadingBar
    extends ReadingBar {
        public CPICHRelativeReadingBar(String string, Color color, int n) {
            super(string, color, n);
        }

        protected int getAbsPower() {
            return ControlChannelBarChartModel.this.measurement.getIntegerReadingValue(8) + ControlChannelBarChartModel.this.measurement.getIntegerReadingValue(this.readingId);
        }
    }

    private class CPICHReadingBar
    extends ReadingBar
    implements TraceBar {
        public CPICHReadingBar(String string, Color color) {
            super(string, color, 8);
        }

        protected int getAbsPower() {
            return ControlChannelBarChartModel.this.measurement.getIntegerReadingValue(this.readingId);
        }

        public int getChannel() {
            return 0;
        }

        public int getSpreadFactor() {
            return 256;
        }

        public boolean matches(int n, int n2) {
            return this.getSpreadFactor() == n && this.getChannel() == n2;
        }
    }

    private abstract class ReadingBar
    extends Bar {
        protected final int readingId;

        public ReadingBar(String string, Color color, int n) {
            super(string, color);
            this.readingId = n;
        }

        public int getValue() {
            int n = this.getAbsPower();
            return ControlChannelBarChartModel.this.settings.isRelative() ? n - ControlChannelBarChartModel.this.measurement.getCdpPower() : n;
        }

        public boolean isActive() {
            if (ControlChannelBarChartModel.this.measurement == null) {
                return false;
            }
            int n = ControlChannelBarChartModel.this.measurement.getIntegerReadingValue(this.readingId);
            return n != -333 && n != -333000 && n != Integer.MIN_VALUE;
        }

        public boolean isEnabled() {
            return true;
        }

        protected abstract int getAbsPower();
    }

    private static interface TraceBar {
        public boolean matches(int var1, int var2);

        public int getChannel();

        public int getSpreadFactor();
    }

    private abstract class Bar {
        final String label;
        final Color color;

        public Bar(String string, Color color) {
            this.label = string;
            this.color = color;
        }

        public abstract boolean isActive();

        public abstract boolean isEnabled();

        public abstract int getValue();
    }
}

