/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.analyzer.ActiveCodeChTablePanel;
import elgato.infrastructure.analyzer.BasicBarChart;
import elgato.infrastructure.analyzer.LabelRotator;
import elgato.infrastructure.analyzer.SpectralChart;
import elgato.infrastructure.analyzer.SpectralChartPanel;
import elgato.infrastructure.analyzer.SpectralDataHistory;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.marker.Marker;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.metrics.BasicMeasurementMetrics;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.measurement.umts.CommonUMTSMeasurementSettings;
import elgato.measurement.umts.ControlChannelBarChartModel;
import elgato.measurement.umts.UMTSChart;
import elgato.measurement.umts.UMTSMeasurement;
import elgato.measurement.umts.UMTSMeasurementSettings;
import elgato.measurement.umts.UMTSMetrics;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UMTSAnalyzer
extends TraceAnalyzer {
    private static final Color ZOOM_WINDOW_FILL = new Color(1671336);
    private static final Color ZOOM_WINDOW_EDGE = new Color(4849648);
    private Container cardPanel;
    private CardLayout cardLayout;
    private String currentCard;
    private SpectralChartPanel spectralChartPanel;
    private ActiveCodeChTablePanel activeCodeChTablePanel;
    private BorderLayout metricsCardLayout;
    private Container metricsCardPanel;
    private Component metricLimitsPanel;
    private JLabel passFailLabel;
    private UMTSChart miniUMTSChart;
    protected BasicBarChart controlChannelChart;
    private static final String BARCHART_CARD = "barchart";
    private static final String CODOGRAM_CARD = "codogram";
    public static final String ACTIVE_CODE_CH_TABLE_CARD = "activeCodeChTable";
    private long lastcodogramTraceCapturedAt;
    private static final DecibelStrategy dbmStrategy = new DecibelStrategy(1, true);
    private static final DecibelStrategy dbStrategy1 = new DecibelStrategy(1, false);
    private int viewMode;
    private int zoomStart;
    private int zoomEnd;
    protected ControlChannelBarChartModel controlChannelModel;
    private SpectralChart codogramTopChart;
    private SpectralChart codogramBottomChart;
    private BorderWrapper chartsPanelWithBorder;
    private SpectralDataHistory codoHistoryData;
    private JPanel mainPanel;
    private UMTSChartsPanel charts;
    private UMTSMeasurement measurement;
    protected BasicMeasurementMetrics metrics;
    CommonUMTSMeasurementSettings settings;
    private JPanel barChartPanelCard;
    private JPanel activeCodeChTablePanelCard;
    private ValueListener codogramEnabledListener;
    private ValueListener codogramPaletteListener;
    private ValueListener viewModeChangeListener;
    private ValueListener positionAndWidthValueListener;
    private ValueListener controlChannelChartRefreshListener;
    private ValueListener activeCodeChTableEnabledListener;
    private LimitStateListener limitStateListener;
    private ValueListener evmModeListener;
    private final NumberFieldStrategy dbStrategy = new DecibelStrategy(1);
    private final NumberFieldStrategy absolutStrategy = new DecibelStrategy(1, true){

        public String format(long l) {
            int n = UMTSAnalyzer.this.getMeasurement().getIntegerReadingValue(39);
            return super.format((long)n + l);
        }
    };
    JComponent activeCodeChTablePanelHeader;
    DynamicLabel activeCodeChTableAveragingLabel;
    private ChannelDescriptionStrategy channelDescriptionStrategy = new ChannelDescriptionStrategy();

    protected int getUMTSActuatorBase() {
        return 19;
    }

    public UMTSAnalyzer(CommonUMTSMeasurementSettings commonUMTSMeasurementSettings, String string) {
        super(string == null ? "UmtsAnalyzer" : string);
        this.settings = commonUMTSMeasurementSettings;
        this.listenToActuator(this.settings.getReference());
        this.listenToActuator(this.settings.getScaleDiv());
        this.controlChannelModel = new ControlChannelBarChartModel(this.getUMTSActuatorBase(), this.settings);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBackground(Color.black);
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setBackground(null);
        this.mainPanel.add((Component)this.cardPanel, "Center");
        this.createMiniUMTSchart();
        this.createControlChannelChart();
        this.createMetricsPanel();
        this.createBarChartPanelCard();
        BorderWrapper borderWrapper = this.createCodogramPanelCard();
        this.createActiveCodeChTablePanelCard();
        this.cardPanel.add((Component)this.barChartPanelCard, BARCHART_CARD);
        this.cardPanel.add((Component)borderWrapper, CODOGRAM_CARD);
        this.cardPanel.add((Component)this.activeCodeChTablePanelCard, ACTIVE_CODE_CH_TABLE_CARD);
        this.initListeners();
        this.settings.getEvmMode().addValueListener(this.evmModeListener);
        this.settings.getViewMode().addValueListener(this.viewModeChangeListener);
        this.settings.getPosition().addValueListener(this.positionAndWidthValueListener);
        this.settings.getWidth().addValueListener(this.positionAndWidthValueListener);
        this.settings.getCodogramEnabled().addValueListener(this.codogramEnabledListener);
        this.settings.getCodogramPalette().addValueListener(this.codogramPaletteListener);
        this.updateCodogramPalette();
        this.settings.getActiveCodeChTableEnabled().addValueListener(this.activeCodeChTableEnabledListener);
        this.settings.getSCCPCHEnabled().addValueListener(this.controlChannelChartRefreshListener);
        this.settings.getPICHEnabled().addValueListener(this.controlChannelChartRefreshListener);
        this.settings.getViewMode().fireValueChanged();
        this.settings.getEvmMode().fireValueChanged();
        this.settings.getActiveCodeChTableEnabled().fireValueChanged();
        this.settings.getCodogramEnabled().fireValueChanged();
        this.settings.getPosition().fireValueChanged();
        this.settings.getWidth().fireValueChanged();
        this.settings.getReference().fireValueChanged();
        for (int i = 0; i < 4; ++i) {
            this.settings.limitsToggleAt(i).addValueListener(this.limitStateListener);
        }
    }

    private void initListeners() {
        this.codogramEnabledListener = new ValueListener(){
            private String listenerName = ".codogramEnabledListener";
            private String baseName = null;

            public String getListenerName() {
                if (this.baseName == null) {
                    this.baseName = UMTSAnalyzer.this.getListenerBaseName();
                    this.listenerName = this.baseName + this.listenerName;
                }
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                boolean bl = valueInterface.booleanValue();
                if (bl) {
                    UMTSAnalyzer.this.currentCard = UMTSAnalyzer.CODOGRAM_CARD;
                } else if (UMTSAnalyzer.this.settings.getActiveCodeChTableEnabled().booleanValue()) {
                    UMTSAnalyzer.this.currentCard = UMTSAnalyzer.ACTIVE_CODE_CH_TABLE_CARD;
                } else {
                    UMTSAnalyzer.this.currentCard = UMTSAnalyzer.BARCHART_CARD;
                }
                UMTSAnalyzer.this.spectralChartPanel.addCharts(bl);
                UMTSAnalyzer.this.cardLayout.show(UMTSAnalyzer.this.cardPanel, UMTSAnalyzer.this.currentCard);
            }
        };
        this.codogramPaletteListener = new ValueListener(){
            private String listenerName = ".codogramPaletteListener";
            private String baseName = null;

            public String getListenerName() {
                if (this.baseName == null) {
                    this.baseName = UMTSAnalyzer.this.getListenerBaseName();
                    this.listenerName = this.baseName + this.listenerName;
                }
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                UMTSAnalyzer.this.updateCodogramPalette();
            }
        };
        this.evmModeListener = new ValueListener(){
            private final String listenerName = "evmModeListener";

            public String getListenerName() {
                return "evmModeListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (UMTSAnalyzer.this.settings.getEvmMode().intValue() == 0) {
                    UMTSAnalyzer.this.metrics.getValueSource(1, 0).setLabel(Text.EVM_COMP);
                } else {
                    UMTSAnalyzer.this.metrics.getValueSource(1, 0).setLabel(Text.EVM_PILOT);
                }
            }
        };
        this.viewModeChangeListener = new ValueListener(){
            private String listenerName = ".viewModeChangeListener";
            private String baseName = null;

            public String getListenerName() {
                if (this.baseName == null) {
                    this.baseName = UMTSAnalyzer.this.getListenerBaseName();
                    this.listenerName = this.baseName + this.listenerName;
                }
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                EventDispatchThread.runOnEventThread("UMTSAnalyzer.configureViewModeOnGUIThread", new Runnable(this, valueInterface){
                    private final /* synthetic */ ValueInterface val$value;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$value = valueInterface;
                    }

                    public void run() {
                        UMTSChartsPanel.access$700(UMTSAnalyzer.access$600(5.access$500(this.this$1)), this.val$value.intValue());
                        5.access$500(this.this$1).setZoomedArea(5.access$500(this.this$1).settings.getPosition().intValue(), 5.access$500(this.this$1).settings.getPosition().intValue() + 5.access$500(this.this$1).settings.getWidth().intValue() - 1);
                        UMTSAnalyzer.access$100(5.access$500(this.this$1)).setViewMode(this.val$value.booleanValue());
                        if (!5.access$500(this.this$1).settings.getActiveCodeChTableEnabled().booleanValue()) {
                            UMTSAnalyzer.access$900(5.access$500(this.this$1)).add((Component)UMTSAnalyzer.access$800(5.access$500(this.this$1)), "South");
                        }
                        5.access$500(this.this$1).validate();
                    }
                });
                UMTSAnalyzer.this.repaint();
            }

            static /* synthetic */ UMTSAnalyzer access$500(5 var0) {
                return var0.UMTSAnalyzer.this;
            }
        };
        this.positionAndWidthValueListener = new ValueListener(){
            private String listenerName = ".positionAndWidthValueListener";
            private String baseName = null;

            public String getListenerName() {
                if (this.baseName == null) {
                    this.baseName = UMTSAnalyzer.this.getListenerBaseName();
                    this.listenerName = this.baseName + this.listenerName;
                }
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                UMTSAnalyzer.this.setZoomedArea(UMTSAnalyzer.this.settings.getPosition().intValue(), UMTSAnalyzer.this.settings.getPosition().intValue() + UMTSAnalyzer.this.settings.getWidth().intValue() - 1);
                UMTSAnalyzer.this.repaint();
            }
        };
        this.controlChannelChartRefreshListener = new ValueListener(){
            private String listenerName = ".controlChannelChartRefreshListener";
            private String baseName = null;

            public String getListenerName() {
                if (this.baseName == null) {
                    this.baseName = UMTSAnalyzer.this.getListenerBaseName();
                    this.listenerName = this.baseName + this.listenerName;
                }
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (UMTSAnalyzer.this.controlChannelChart != null && UMTSAnalyzer.this.getMeasurement() != null) {
                    UMTSAnalyzer.this.controlChannelChart.refresh();
                    UMTSAnalyzer.this.controlChannelChart.repaint();
                }
            }
        };
        this.activeCodeChTableEnabledListener = new ValueListener(){
            private String listenerName = ".activeCodeChTableEnabledListener";
            private String baseName = null;

            public String getListenerName() {
                if (this.baseName == null) {
                    this.baseName = UMTSAnalyzer.this.getListenerBaseName();
                    this.listenerName = this.baseName + this.listenerName;
                }
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                boolean bl = valueInterface.booleanValue();
                if (bl) {
                    UMTSAnalyzer.this.currentCard = UMTSAnalyzer.ACTIVE_CODE_CH_TABLE_CARD;
                } else if (UMTSAnalyzer.this.settings.getCodogramEnabled().booleanValue()) {
                    UMTSAnalyzer.this.currentCard = UMTSAnalyzer.CODOGRAM_CARD;
                } else {
                    UMTSAnalyzer.this.currentCard = UMTSAnalyzer.BARCHART_CARD;
                }
                UMTSAnalyzer.this.settings.getViewMode().fireValueChanged();
                UMTSAnalyzer.this.activeCodeChTablePanel.addCharts(bl);
                UMTSAnalyzer.this.validate();
                UMTSAnalyzer.this.cardLayout.show(UMTSAnalyzer.this.cardPanel, UMTSAnalyzer.this.currentCard);
            }
        };
        this.limitStateListener = new LimitStateListener(this);
    }

    public void dispose() {
        this.settings.getViewMode().removeValueListener(this.viewModeChangeListener);
        this.settings.getPosition().removeValueListener(this.positionAndWidthValueListener);
        this.settings.getWidth().removeValueListener(this.positionAndWidthValueListener);
        this.settings.getCodogramEnabled().removeValueListener(this.codogramEnabledListener);
        this.settings.getCodogramPalette().removeValueListener(this.codogramPaletteListener);
        this.settings.getActiveCodeChTableEnabled().removeValueListener(this.activeCodeChTableEnabledListener);
        this.settings.getSCCPCHEnabled().removeValueListener(this.controlChannelChartRefreshListener);
        this.settings.getEvmMode().removeValueListener(this.evmModeListener);
        this.settings.getPICHEnabled().removeValueListener(this.controlChannelChartRefreshListener);
        for (int i = 0; i < 4; ++i) {
            this.settings.limitsToggleAt(i).removeValueListener(this.limitStateListener);
        }
        this.viewModeChangeListener = null;
        this.positionAndWidthValueListener = null;
        this.codogramEnabledListener = null;
        this.codogramPaletteListener = null;
        this.activeCodeChTableEnabledListener = null;
        this.evmModeListener = null;
        this.controlChannelChartRefreshListener = null;
        this.limitStateListener = null;
        this.activeCodeChTablePanel.dispose();
        super.dispose();
    }

    private void createBarChartPanelCard() {
        this.barChartPanelCard = new JPanel(new BorderLayout());
        this.barChartPanelCard.setBackground(null);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(null);
        jPanel.add((Component)this.createHeaderPanel(), "North");
        this.charts = this.createChartsPanel();
        this.charts.setBackground(null);
        jPanel.add((Component)this.charts, "Center");
        this.chartsPanelWithBorder = new BorderWrapper(jPanel, TraceAnalyzer.getChartBorder(), true);
        this.barChartPanelCard.add((Component)this.chartsPanelWithBorder, "Center");
        this.barChartPanelCard.add((Component)this.metricsCardPanel, "South");
    }

    private void createMetricsPanel() {
        this.metricsCardLayout = new BorderLayout();
        this.metricsCardPanel = new JPanel(this.metricsCardLayout);
        this.metrics = this.createMetrics();
        this.metricLimitsPanel = this.createMetricsLimitsPanel();
        this.metricLimitsPanel.setVisible(false);
        this.metricsCardPanel.add((Component)new BorderWrapper(this.metrics, MeasurementMetrics.BORDER, true), "North");
        this.metricsCardPanel.add(this.metricLimitsPanel, "South");
    }

    protected JComponent createHeaderPanel() {
        float[][] fArrayArray = new float[][]{{-1.0f, -1.0f, -1.0f}, {-2.0f, -2.0f}};
        TableLayout tableLayout = new TableLayout(fArrayArray);
        JPanel jPanel = new JPanel(tableLayout);
        jPanel.add((Component)this.addLabel(new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return UMTSAnalyzer.this.getCurrentMarkerDescription();
            }
        }), "0,0,2,0");
        jPanel.add((Component)this.addLabel(new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return Text.RF_IN_Loss + " " + UIHelper.formatFixed(UMTSAnalyzer.this.getUMTSMeasurement().getAttenuation(), 1) + " dB";
            }
        }), "2,1");
        jPanel.add((Component)this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                if (UMTSAnalyzer.this.settings.getEqStatus().intValue() == 0) {
                    return "";
                }
                if (UMTSAnalyzer.this.settings.getEqStatus().intValue() == 1) {
                    return Text.EQ_Running;
                }
                return Text.EQ_Holding;
            }
        }), "0,1");
        jPanel.setBackground(null);
        return jPanel;
    }

    private void createMiniUMTSchart() {
        this.miniUMTSChart = new UMTSChart(this.controlChannelModel, this.settings, this);
        this.miniUMTSChart.setSlotRange(0, 511);
        this.miniUMTSChart.setSlotSpacing(0);
        this.miniUMTSChart.setZoomOutFactor(4);
        this.miniUMTSChart.setDrawLocationLabels(true);
    }

    private void createControlChannelChart() {
        this.controlChannelChart = new BasicBarChart(this.controlChannelModel, new LabelRotator());
        this.controlChannelChart.setDrawYAxisLabels(true);
        BasicBarChart basicBarChart = this.controlChannelChart;
        basicBarChart.getClass();
        this.controlChannelChart.setYGridType(basicBarChart.new TraceChart.EvenYDivisions(5));
        this.controlChannelChart.setWidestYAxisString("-999.9");
    }

    private BorderWrapper createCodogramPanelCard() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createHeaderPanel(), "North");
        jPanel.setBackground(null);
        this.codoHistoryData = new SpectralDataHistory(512);
        this.codogramTopChart = new SpectralChart(this.codoHistoryData);
        this.codogramTopChart.setDrawLocationLabels(true);
        this.codogramTopChart.setXAxisLinearity(false);
        this.codogramBottomChart = new SpectralChart(this.codoHistoryData);
        this.codogramBottomChart.setDrawLocationLabels(true);
        this.codogramBottomChart.setXAxisLinearity(false);
        this.codogramBottomChart.setSlotRange(256, 511);
        this.spectralChartPanel = new SpectralChartPanel(this.codogramTopChart, this.codogramBottomChart, this.miniUMTSChart);
        jPanel.add((Component)this.spectralChartPanel, "Center");
        return new BorderWrapper(jPanel, TraceAnalyzer.getChartBorder(), true);
    }

    private void updateCodogramPalette() {
        SpectralChart.PaletteMaker[] paletteMakerArray = SpectralChart.getAllPalettes();
        int n = this.settings.getCodogramPalette().intValue();
        SpectralChart.Palette palette = paletteMakerArray[n].createPalette();
        this.spectralChartPanel.getSpectralChart().setPalette(palette);
        this.codogramBottomChart.setPalette(palette);
    }

    public void setZoomedArea(int n, int n2) {
        this.zoomStart = n;
        this.zoomEnd = n2;
        if (this.viewMode == 1 || this.settings.getActiveCodeChTableEnabled().booleanValue()) {
            this.codogramTopChart.setSlotRange(0, 255);
            this.miniUMTSChart.setZoomSection(0, 0);
        } else {
            this.charts.setZoomedArea(this.zoomStart, this.zoomEnd);
            this.codogramTopChart.setSlotRange(this.zoomStart, this.zoomEnd);
            this.miniUMTSChart.setZoomSection(this.zoomStart, this.zoomEnd);
        }
    }

    private void createActiveCodeChTablePanelCard() {
        this.activeCodeChTablePanelCard = new JPanel(new BorderLayout());
        this.activeCodeChTablePanelHeader = this.createHeaderPanel();
        this.activeCodeChTablePanelCard.add((Component)this.activeCodeChTablePanelHeader, "North");
        this.activeCodeChTablePanelCard.setBackground(null);
        this.activeCodeChTableAveragingLabel = this.createAverageLabelToTopChart();
        this.activeCodeChTablePanel = new ActiveCodeChTablePanel(this.miniUMTSChart, this.controlChannelChart, this.metricsCardPanel, this.activeCodeChTableAveragingLabel);
        this.activeCodeChTablePanelCard.add((Component)this.activeCodeChTablePanel, "Center");
    }

    protected UMTSChartsPanel createChartsPanel() {
        return new UMTSChartsPanel(this);
    }

    protected BasicMeasurementMetrics createMetrics() {
        return new UMTSMetrics(this);
    }

    public MeasurementMetrics getMeasurementMetrics() {
        return this.metrics;
    }

    private boolean isAbsoluteReference() {
        return this.settings.getReference().intValue() == 1;
    }

    public void updateChartVerticalRange() {
        int n = 0;
        TraceChart[] traceChartArray = this.charts.getAllCharts();
        boolean bl = this.settings.isRelative();
        if (this.getMeasurement() != null) {
            n = bl ? 0 : this.getUMTSMeasurement().getCdpPower();
        }
        int n2 = n - this.settings.getScaleDiv().intValue() * 10;
        DecibelStrategy decibelStrategy = bl ? dbStrategy1 : dbmStrategy;
        for (int i = 0; i < traceChartArray.length; ++i) {
            TraceChart traceChart = traceChartArray[i];
            if (traceChart == null) continue;
            traceChart.setVerticalRange(n, n2);
            traceChart.setyAxisStrategy(decibelStrategy);
        }
        if (this.spectralChartPanel != null) {
            if (this.isAbsoluteReference() & this.getUMTSMeasurement() != null) {
                this.spectralChartPanel.setVerticalLegendOffset(this.getUMTSMeasurement().getCdpPower(), dbmStrategy);
            } else {
                this.spectralChartPanel.setVerticalLegendOffset(0, dbStrategy1);
            }
            this.spectralChartPanel.setVerticalRange(0, -this.settings.getScaleDiv().intValue() * 10);
        }
        if (this.miniUMTSChart != null) {
            this.miniUMTSChart.setVerticalRange(n, n2);
            this.miniUMTSChart.setyAxisStrategy(decibelStrategy);
        }
    }

    protected void updateChartMeasurements() {
        boolean bl;
        super.updateChartMeasurements();
        UMTSMeasurement uMTSMeasurement = (UMTSMeasurement)this.getMeasurement();
        if (uMTSMeasurement == null) {
            return;
        }
        long l = this.settings.getSpectrogramCaptureInterval().longValue() * 1000L;
        long l2 = System.currentTimeMillis();
        if (l == 0L) {
            bl = true;
        } else {
            long l3 = this.lastcodogramTraceCapturedAt;
            if (l3 <= 0L) {
                bl = true;
            } else {
                boolean bl2 = bl = l2 >= l3 + l;
            }
        }
        if (bl) {
            int n;
            this.lastcodogramTraceCapturedAt = l2;
            int n2 = uMTSMeasurement.getNumBars();
            int[] nArray = new int[512];
            int[] nArray2 = new int[512];
            int n3 = 0;
            for (n = 0; n < n2 && n3 < nArray.length; ++n) {
                int n4 = uMTSMeasurement.getBarWidth(n);
                int n5 = uMTSMeasurement.getTrace()[n];
                int n6 = uMTSMeasurement.getAbsBarPower(n);
                int n7 = n3 + n4;
                if (n7 > nArray.length) break;
                while (n3 < n7) {
                    nArray[n3] = n5;
                    nArray2[n3] = n6;
                    ++n3;
                }
            }
            this.codoHistoryData.storeData(nArray, nArray2, uMTSMeasurement.getIntegerReadingValue(39));
            this.spectralChartPanel.update();
            this.activeCodeChTablePanel.updateTable(uMTSMeasurement.getActiveCodeChannels());
            n = -1;
            if (this.getMarkerButtonFactory() != null) {
                this.getMarkerButtonFactory().updateActivity();
                Marker marker = this.getMarkerButtonFactory().getCurrentMarker();
                if (marker != null && marker.getMarkerModel().showingNormal() && this.getMarkerButtonFactory().getCurrentMarkerAtActiveIndex(this) && (n = this.getMarkerButtonFactory().getCurrentMarkerActiveIndex()) > uMTSMeasurement.getNumBars()) {
                    n = uMTSMeasurement.getNumBars();
                }
            }
            this.activeCodeChTablePanel.setSelectedRow(n);
            this.updateChartVerticalRange();
        }
    }

    public Measurement getMeasurement() {
        return this.getUMTSMeasurement();
    }

    protected UMTSMeasurement getUMTSMeasurement() {
        return this.measurement;
    }

    protected void setMeasurement(Measurement measurement) {
        if (this.measurement != null) {
            this.measurement.recycle();
        }
        this.measurement = (UMTSMeasurement)measurement;
    }

    protected void doUpdateChartMarkers() {
        super.doUpdateChartMarkers();
        this.codogramTopChart.setMarkers(this.getMarkerButtonFactory().getMarkers());
        this.codogramBottomChart.setMarkers(this.getMarkerButtonFactory().getMarkers());
    }

    protected void updateLabels() {
        super.updateLabels();
        UMTSMeasurement uMTSMeasurement = (UMTSMeasurement)this.getMeasurement();
        if (uMTSMeasurement != null && this.settings.getActiveCodeChTableEnabled().booleanValue()) {
            Marker marker;
            this.activeCodeChTableAveragingLabel.setMeasurement(uMTSMeasurement);
            int n = -1;
            if (this.getMarkerButtonFactory() != null && (marker = this.getMarkerButtonFactory().getCurrentMarker()) != null && marker.getMarkerModel().showingNormal() && this.getMarkerButtonFactory().getCurrentMarkerAtActiveIndex(this) && (n = this.getMarkerButtonFactory().getCurrentMarkerActiveIndex()) > uMTSMeasurement.getNumBars()) {
                n = uMTSMeasurement.getNumBars();
            }
            this.activeCodeChTablePanel.setSelectedRow(n);
        }
    }

    protected Component getPane() {
        return this.mainPanel;
    }

    protected TraceChart getChart() {
        return this.charts.getAllCharts()[0];
    }

    protected TraceChart[] getCharts() {
        return this.charts.getAllCharts();
    }

    public TabDelimitable[] createReadingFields() {
        TabDelimitable[] tabDelimitableArray;
        UMTSMeasurement uMTSMeasurement = (UMTSMeasurement)this.getMeasurement();
        int n = uMTSMeasurement.getNumBars();
        int n2 = 0;
        int n3 = 0;
        TabDelimitable[] tabDelimitableArray2 = this.metrics.getTabDelimitables();
        int n4 = tabDelimitableArray2.length;
        if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() == 1) {
            String string;
            String string2;
            int n5;
            n2 = 5;
            tabDelimitableArray = new TabDelimitable[n4 + n + n2];
            for (n5 = 0; n5 < n4; ++n5) {
                tabDelimitableArray[n3++] = tabDelimitableArray2[n5];
            }
            n5 = UMTSMeasurementSettings.instance().isRelative() ? 1 : 0;
            int n6 = n5 != 0 ? uMTSMeasurement.getIntegerReadingValue(14) : uMTSMeasurement.getAbsCdpTraceThreshold();
            float f = this.convertPowerToFloat(n6);
            if (n5 != 0) {
                string2 = "Channel Power (dB)";
                string = "dB";
            } else {
                string2 = "Channel Power (dBm)";
                string = "dBm";
            }
            tabDelimitableArray[n3++] = new TraceSaveTabDelimitable("");
            tabDelimitableArray[n3++] = new TraceSaveTabDelimitable("Trace Data");
            tabDelimitableArray[n3++] = new TraceSaveTabDelimitable("Bar Count\t" + String.valueOf(n));
            tabDelimitableArray[n3++] = new TraceSaveTabDelimitable("CDP Power Threshold\t" + String.valueOf(f) + '\t' + string);
            tabDelimitableArray[n3++] = new TraceSaveTabDelimitable("Bar #\tChannel Number\t" + string2 + "\tSpread Factor\tChannel Type");
            for (int i = 0; i < n; ++i) {
                int n7 = n5 != 0 ? uMTSMeasurement.getRelBarPower(i) : uMTSMeasurement.getAbsBarPower(i);
                float f2 = this.convertPowerToFloat(n7);
                String string3 = String.valueOf(i + 1) + '\t' + String.valueOf(uMTSMeasurement.getChannelNumberForBar(i)) + '\t' + String.valueOf(f2) + '\t' + String.valueOf(uMTSMeasurement.getSpreadFactor(i)) + '\t' + this.controlChannelModel.getLabelForChannel(uMTSMeasurement.getChannelType(i));
                tabDelimitableArray[n3++] = new TraceSaveTabDelimitable(string3);
            }
        } else {
            tabDelimitableArray = new TabDelimitable[n4];
            for (int i = 0; i < n4; ++i) {
                tabDelimitableArray[n3++] = tabDelimitableArray2[i];
            }
        }
        return tabDelimitableArray;
    }

    public NumberFieldStrategy getYAxisNormalStrategy() {
        return this.isRelativeMode() ? this.dbStrategy : this.absolutStrategy;
    }

    private boolean isRelativeMode() {
        return this.settings.getReference().intValue() == 0;
    }

    public NumberFieldStrategy getYAxisDeltaStrategy() {
        return this.dbStrategy;
    }

    public NumberFieldStrategy getXAxisStrategy() {
        return this.channelDescriptionStrategy;
    }

    protected int getIndexForXValue(long l) {
        return this.getUMTSMeasurement().getIndexForXValue(l);
    }

    protected int getSpreadFactor(int n) {
        return this.getUMTSMeasurement().getSpreadFactor(n);
    }

    protected int getChannelNumberForBar(int n) {
        return this.getUMTSMeasurement().getChannelNumberForBar(n);
    }

    protected int getChannelTypeForBar(int n) {
        return this.getUMTSMeasurement().getChannelType(n);
    }

    protected int getAbsBarPower(int n) {
        return this.getUMTSMeasurement().getAbsBarPower(n);
    }

    protected int getAbsCdpTraceThreshold() {
        return this.getUMTSMeasurement().getAbsCdpTraceThreshold();
    }

    public ActiveCodeChTablePanel getActiveCodeChTable() {
        return this.activeCodeChTablePanel;
    }

    protected TraceAnalyzer.AverageDynamicLabel createAverageLabelToTopChart() {
        return new TraceAnalyzer.AverageDynamicLabel(27, 28, 34);
    }

    public void clearCodogramHistory() {
        this.spectralChartPanel.clearSpectrogramHistory();
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        if (this.currentCard == BARCHART_CARD) {
            rectangle = this.chartsPanelWithBorder.getBounds();
            rectangle.x += n;
            rectangle.y += n2;
        } else if (this.currentCard == ACTIVE_CODE_CH_TABLE_CARD) {
            rectangle = this.activeCodeChTablePanelHeader.getBounds();
            int n3 = rectangle.height;
            rectangle = this.getActiveCodeChTable().getChartsPanelBounds();
            rectangle.x += n;
            rectangle.y += n2;
            rectangle.height += n3;
        }
        return super.filterPrintImage(image, rectangle);
    }

    public void swapBottomPanel(boolean bl) {
        this.metricLimitsPanel.setVisible(bl);
        this.validate();
        this.repaint();
    }

    private Component createMetricsLimitsPanel() {
        JPanel jPanel = new JPanel();
        this.passFailLabel = new JLabel();
        jPanel.add(this.passFailLabel);
        return new BorderWrapper(jPanel, MeasurementMetrics.BORDER, true);
    }

    protected void setPassFailLabel() {
        if (this.areAllWithinLimits()) {
            this.passFailLabel.setForeground(MeasurementMetrics.DARK_GREEN);
            this.passFailLabel.setText("ALL PASS");
        } else {
            this.passFailLabel.setForeground(Color.red);
            this.passFailLabel.setText("FAILURE");
        }
    }

    public boolean isLimitOn(int n) {
        return this.settings.limitsToggleAt(n).getSelectedValue().longValue() == 1L;
    }

    public boolean areAllWithinLimits() {
        if (this.isLimitOn(0) && !this.isFreqErrorWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(1) && !this.isEvmWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(2) && !this.isPcdeWithinLimits()) {
            return false;
        }
        return !this.isLimitOn(3) || this.isCpichWithinLimits();
    }

    public boolean isFreqErrorWithinLimits() {
        int n = this.measurement.getFreqError();
        return this.settings.getFreqErrorUpperLimit().longValue() >= (long)n && (long)n >= this.settings.getFreqErrorLowerLimit().longValue();
    }

    public boolean isEvmWithinLimits() {
        int n = this.measurement.getEvm();
        int n2 = this.settings.getEvmUpperLimit_QpskOnly().intValue();
        for (int i = 0; i < 512; ++i) {
            if (this.measurement.getChannelType(i) != 8) continue;
            n2 = this.settings.getEvmUpperLimit_inclQam().intValue();
            break;
        }
        return n != -333000 && n2 >= n;
    }

    public boolean isPcdeWithinLimits() {
        int n = this.measurement.getPcde();
        return n != -333000 && this.settings.getPcdeUpperLimit().intValue() >= n;
    }

    public boolean isCpichWithinLimits() {
        int n = this.measurement.getCpich();
        int n2 = this.measurement.getChannelPower() + this.settings.getCpichUpperLimit().intValue();
        int n3 = this.measurement.getChannelPower() + this.settings.getCpichLowerLimit().intValue();
        return n2 >= n && n3 <= n;
    }

    static /* synthetic */ UMTSChartsPanel access$600(UMTSAnalyzer uMTSAnalyzer) {
        return uMTSAnalyzer.charts;
    }

    static /* synthetic */ Container access$800(UMTSAnalyzer uMTSAnalyzer) {
        return uMTSAnalyzer.metricsCardPanel;
    }

    static /* synthetic */ JPanel access$900(UMTSAnalyzer uMTSAnalyzer) {
        return uMTSAnalyzer.barChartPanelCard;
    }

    private class ChannelDescriptionStrategy
    extends NumberFieldStrategy {
        private ChannelDescriptionStrategy() {
        }

        public String format(long l) {
            int n = UMTSAnalyzer.this.getIndexForXValue(l);
            int n2 = UMTSAnalyzer.this.getSpreadFactor(n);
            int n3 = UMTSAnalyzer.this.getChannelNumberForBar(n);
            int n4 = UMTSAnalyzer.this.measurement.getChannelType(n);
            String string = UMTSAnalyzer.this.controlChannelModel.getLabelForChannel(n4);
            boolean bl = UMTSAnalyzer.this.measurement.isBarActive(n);
            StringBuffer stringBuffer = new StringBuffer(26);
            stringBuffer.append(n2).append('(').append(n3).append("), ").append(string);
            if (bl) {
                int n5 = 7500 * (512 / n2);
                stringBuffer.append(' ');
                stringBuffer.append(n5 / 1000);
                int n6 = n5 % 1000;
                if (n6 != 0) {
                    int n7;
                    stringBuffer.append(".");
                    for (int i = 100; i != 0 && n6 != 0; n6 -= n7 * i, i /= 10) {
                        n7 = n6 / i;
                        stringBuffer.append(n7);
                    }
                }
                if (n4 == 7 || n4 == 8) {
                    stringBuffer.append(" k");
                } else {
                    stringBuffer.append(" ksps");
                }
            }
            return stringBuffer.toString();
        }
    }

    protected class UMTSChartsPanel
    extends JPanel {
        private TraceChart[] charts;
        private UMTSChart topChart;
        private UMTSChart bottomChart;
        private UMTSAnalyzer analyzer;
        int[] funnelXs = new int[8];
        int[] funnelYs = new int[8];
        int[] fillXs = new int[6];
        int[] fillYs = new int[6];

        public UMTSChartsPanel(UMTSAnalyzer uMTSAnalyzer2) {
            super(new TableLayout(new float[][]{{-1.0f, 0.0f, 0.35f}, {-1.0f, 12.0f, -1.0f}}));
            this.analyzer = uMTSAnalyzer2;
        }

        public TraceChart[] getAllCharts() {
            return this.charts;
        }

        public void setZoomedArea(int n, int n2) {
            if (UMTSAnalyzer.this.viewMode == 0) {
                if (this.bottomChart != null) {
                    this.bottomChart.setSlotRange(n, n2);
                }
                UMTSAnalyzer.this.codogramTopChart.setSlotRange(n, n2);
                UMTSAnalyzer.this.miniUMTSChart.setZoomSection(n, n2);
            } else {
                UMTSAnalyzer.this.codogramTopChart.setSlotRange(0, 255);
                UMTSAnalyzer.this.miniUMTSChart.setZoomSection(0, 0);
            }
        }

        protected TraceChart getTopRightChart() {
            return UMTSAnalyzer.this.controlChannelChart;
        }

        protected JComponent getTopRightPanel() {
            return UMTSAnalyzer.this.controlChannelChart;
        }

        protected TraceChart getBottomRightChart() {
            return null;
        }

        protected UMTSChart getTopChart() {
            return this.topChart;
        }

        public UMTSChart getBottomChart() {
            return this.bottomChart;
        }

        private void setViewModeAndInstallCharts(int n) {
            UMTSAnalyzer.this.viewMode = n;
            this.removeAll();
            if (UMTSAnalyzer.this.settings.getActiveCodeChTableEnabled().booleanValue()) {
                this.charts = new TraceChart[]{UMTSAnalyzer.this.controlChannelChart, UMTSAnalyzer.this.miniUMTSChart};
            } else {
                switch (n) {
                    case 1: {
                        this.topChart = new UMTSChart(UMTSAnalyzer.this.controlChannelModel, UMTSAnalyzer.this.settings, this.analyzer);
                        this.topChart.setSlotRange(0, 255);
                        this.topChart.setSlotSpacing(0);
                        this.topChart.setDrawYAxisLabels(true);
                        this.topChart.setWidestYAxisString("-999.9");
                        this.topChart.setDrawLocationLabels(true);
                        this.topChart.addDLabel(UMTSAnalyzer.this.createAverageLabelToTopChart(), 280, 13);
                        this.bottomChart = new UMTSChart(UMTSAnalyzer.this.controlChannelModel, UMTSAnalyzer.this.settings, this.analyzer);
                        this.bottomChart.setSlotRange(256, 511);
                        this.bottomChart.setSlotSpacing(0);
                        this.bottomChart.setDrawYAxisLabels(true);
                        this.bottomChart.setWidestYAxisString("-999.9");
                        this.bottomChart.setDrawLocationLabels(true);
                        this.charts = new TraceChart[]{this.topChart, this.bottomChart, this.getTopRightChart(), UMTSAnalyzer.this.controlChannelChart, UMTSAnalyzer.this.miniUMTSChart};
                        this.add((Component)this.topChart, "0,0");
                        this.add((Component)this.bottomChart, "0,2");
                        this.add((Component)this.getTopRightPanel(), "2,0");
                        if (this.getBottomRightChart() == null) break;
                        this.add((Component)this.getBottomRightChart(), "2,2");
                        break;
                    }
                    case 0: {
                        this.topChart = new UMTSChart(UMTSAnalyzer.this.controlChannelModel, UMTSAnalyzer.this.settings, this.analyzer);
                        this.topChart.setSlotRange(0, 511);
                        this.topChart.setSlotSpacing(0);
                        this.topChart.setZoomOutFactor(2);
                        this.topChart.setDrawYAxisLabels(true);
                        UMTSChart uMTSChart = this.topChart;
                        uMTSChart.getClass();
                        this.topChart.setYGridType(uMTSChart.new TraceChart.EvenYDivisions(5));
                        this.topChart.setWidestYAxisString("-999.9");
                        this.topChart.setDrawLocationLabels(true);
                        this.topChart.setAlignment(0);
                        this.topChart.addDLabel(UMTSAnalyzer.this.createAverageLabelToTopChart(), 280, 13);
                        this.bottomChart = new UMTSChart(UMTSAnalyzer.this.controlChannelModel, UMTSAnalyzer.this.settings, this.analyzer);
                        this.bottomChart.setSlotRange(UMTSAnalyzer.this.zoomStart, UMTSAnalyzer.this.zoomEnd);
                        this.bottomChart.setSlotSpacing(1);
                        this.bottomChart.setDrawYAxisLabels(true);
                        this.bottomChart.setWidestYAxisString("-999.9");
                        this.bottomChart.setAlignment(0);
                        this.add((Component)this.topChart, "0,0");
                        this.charts = new TraceChart[]{this.topChart, this.bottomChart, this.getTopRightChart(), UMTSAnalyzer.this.controlChannelChart, UMTSAnalyzer.this.miniUMTSChart};
                        this.add((Component)this.getTopRightPanel(), "2,0");
                        this.add((Component)this.bottomChart, "0,2,2,2");
                    }
                }
            }
            UMTSAnalyzer.this.updateChartVerticalRange();
            UMTSAnalyzer.this.updateChartMeasurements();
            UMTSAnalyzer.this.updateChartMarkers();
        }

        protected void paintChildren(Graphics graphics) {
            super.paintChildren(graphics);
            if (UMTSAnalyzer.this.viewMode == 0 && this.topChart instanceof UMTSChart && this.bottomChart instanceof UMTSChart && UMTSAnalyzer.this.getMeasurement() != null) {
                Rectangle rectangle = this.topChart.getBounds();
                Rectangle rectangle2 = this.bottomChart.getBounds();
                int n = rectangle.y + this.topChart.getPaintBottom();
                int n2 = rectangle.x + this.topChart.getChannelLeftX(this.bottomChart.getStartSlot());
                int n3 = rectangle.x + this.topChart.getChannelRightX(this.bottomChart.getEndSlot());
                int n4 = rectangle2.y + this.bottomChart.getPaintTop();
                int n5 = rectangle2.x + this.bottomChart.getChannelLeftX(this.bottomChart.getStartSlot());
                int n6 = rectangle2.x + this.bottomChart.getChannelRightX(this.bottomChart.getEndSlot());
                int n7 = this.topChart.getLocationLabelsBarHeight() + 1;
                this.funnelXs[0] = n2;
                this.funnelYs[0] = n;
                this.funnelXs[1] = n2;
                this.funnelYs[1] = n + n7;
                this.funnelXs[2] = n5;
                this.funnelYs[2] = n4 - 3;
                this.funnelXs[3] = n5;
                this.funnelYs[3] = n4;
                this.funnelXs[4] = n6;
                this.funnelYs[4] = n4;
                this.funnelXs[5] = n6;
                this.funnelYs[5] = n4 - 3;
                this.funnelXs[6] = n3;
                this.funnelYs[6] = n + n7;
                this.funnelXs[7] = n3;
                this.funnelYs[7] = n;
                System.arraycopy(this.funnelXs, 1, this.fillXs, 0, this.fillXs.length);
                System.arraycopy(this.funnelYs, 1, this.fillYs, 0, this.fillYs.length);
                graphics.setColor(ZOOM_WINDOW_FILL);
                graphics.fillPolygon(this.fillXs, this.fillYs, this.fillXs.length);
                graphics.setColor(ZOOM_WINDOW_EDGE);
                graphics.drawPolygon(this.funnelXs, this.funnelYs, this.funnelXs.length);
            }
        }

        public void updateYAxisStrategy() {
            FixedPointNumberFieldStrategy fixedPointNumberFieldStrategy = new FixedPointNumberFieldStrategy(1, UMTSAnalyzer.this.controlChannelModel.getValueUnits());
            for (int i = 0; i < this.charts.length; ++i) {
                TraceChart traceChart = this.charts[i];
                if (traceChart == null) continue;
                traceChart.setyAxisStrategy(fixedPointNumberFieldStrategy);
            }
        }

        static /* synthetic */ void access$700(UMTSChartsPanel uMTSChartsPanel, int n) {
            uMTSChartsPanel.setViewModeAndInstallCharts(n);
        }
    }

    private static class LimitStateListener
    implements ValueListener {
        private String listenerName = ".limitsSummaryListener";
        private String baseName = null;
        private UMTSAnalyzer analyzer;

        public LimitStateListener(UMTSAnalyzer uMTSAnalyzer) {
            this.analyzer = uMTSAnalyzer;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.analyzer.swapBottomPanel(this.analyzer.settings.getLimitsSummaryState());
        }
    }
}

