/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.analyzer.BarChart;
import elgato.infrastructure.marker.Marker;
import elgato.measurement.umts.CommonUMTSMeasurementSettings;
import elgato.measurement.umts.ControlChannelBarChartModel;
import elgato.measurement.umts.UMTSAnalyzer;
import elgato.measurement.umts.UMTSMeasurement;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

class UMTSChart
extends BarChart {
    private static final int LOCATION_LABELS_HEIGHT = 11;
    private final Font walshFont = new Font("SansSerif", 0, 9);
    private int startSlot;
    private int endSlot;
    private int slotSpacing;
    private int zoomOutFactor = 1;
    private int zoomStart = 0;
    private int zoomEnd = 0;
    private ControlChannelBarChartModel controlChannelBarChartModel;
    private boolean drawLocationLabels;
    CommonUMTSMeasurementSettings settings;
    private UMTSAnalyzer analyzer;
    private int paintX1;
    private int paintY1;
    private int paintH;
    private int[] xPts = new int[512];
    private int[] yPts = new int[512];
    private int[] barNums = new int[512];
    private int[] barPowers = new int[512];
    private int[] barWidths = new int[512];
    private int[] barX0s = new int[512];
    private int[] barPhysicalPixelWidths = new int[512];
    private int[] barWidthSums = new int[512];
    private boolean[] barDoneFlags = new boolean[512];
    private boolean[] barDeletedFlags = new boolean[512];

    public UMTSChart(ControlChannelBarChartModel controlChannelBarChartModel, CommonUMTSMeasurementSettings commonUMTSMeasurementSettings, UMTSAnalyzer uMTSAnalyzer) {
        this.controlChannelBarChartModel = controlChannelBarChartModel;
        this.settings = commonUMTSMeasurementSettings;
        this.analyzer = uMTSAnalyzer;
    }

    public UMTSChart(ControlChannelBarChartModel controlChannelBarChartModel, CommonUMTSMeasurementSettings commonUMTSMeasurementSettings) {
        this.controlChannelBarChartModel = controlChannelBarChartModel;
        this.settings = commonUMTSMeasurementSettings;
    }

    public void dispose() {
        this.controlChannelBarChartModel = null;
        this.settings = null;
        this.analyzer = null;
    }

    public void setAnalyzer(UMTSAnalyzer uMTSAnalyzer) {
        this.analyzer = uMTSAnalyzer;
    }

    public void setSlotRange(int n, int n2) {
        this.startSlot = n;
        this.endSlot = n2;
    }

    public int getStartSlot() {
        return this.startSlot;
    }

    public int getEndSlot() {
        return this.endSlot;
    }

    public void setZoomOutFactor(int n) {
        this.zoomOutFactor = n;
    }

    public void setZoomSection(int n, int n2) {
        this.zoomStart = n;
        this.zoomEnd = n2;
    }

    public boolean isLabelBars() {
        int n = this.endSlot - this.startSlot + 1;
        return n <= 32;
    }

    public boolean isDrawLocationLabels() {
        return this.drawLocationLabels;
    }

    public void setDrawLocationLabels(boolean bl) {
        this.drawLocationLabels = bl;
    }

    public int getLocationLabelsBarHeight() {
        return 11;
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        UMTSMeasurement uMTSMeasurement = (UMTSMeasurement)this.getMeasurement();
        int n15 = this.getUnitBarWidth();
        int n16 = this.getSlotSpacing();
        int n17 = this.getYTop();
        int n18 = this.getYBottom() - n17;
        if (n3 <= 0 || n4 <= 0 || n18 == 0) {
            return;
        }
        graphics.translate(n, n2);
        this.paintX1 = n;
        this.paintY1 = n2;
        this.paintH = n4;
        boolean bl = this.isLabelBars();
        int n19 = uMTSMeasurement.getNumBars();
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        for (n14 = 0; n14 < n19; ++n14) {
            n13 = uMTSMeasurement.getChannelNumberForBar(n14);
            n12 = uMTSMeasurement.getBarWidth(n14);
            n22 += n12;
            n11 = n13 * n12;
            n10 = n12;
            n9 = this.startSlot - n11;
            if (n9 > 0) {
                n10 -= n9;
                n11 += n9;
            }
            if ((n8 = n11 + n10 - this.endSlot - 1) > 0) {
                n10 -= n8;
            }
            if (n11 > this.endSlot || n10 <= 0) continue;
            n7 = this.settings.isRelative() ? uMTSMeasurement.getRelBarPower(n14) : uMTSMeasurement.getAbsBarPower(n14);
            n6 = n10 * n15 + (n10 - 1) * n16;
            n5 = n21 / this.zoomOutFactor;
            int n23 = n6 / this.zoomOutFactor;
            if (n23 == 0) {
                n23 = 1;
            }
            this.barNums[n20] = n14;
            this.barPowers[n20] = n7;
            this.barX0s[n20] = n5;
            this.barWidths[n20] = n12;
            this.barWidthSums[n20] = n22;
            this.barPhysicalPixelWidths[n20] = n23;
            ++n20;
            n21 += n6 + n16;
        }
        for (n14 = 0; n14 < n20; ++n14) {
            this.barDoneFlags[n14] = false;
            this.barDeletedFlags[n14] = false;
        }
        for (n14 = 0; n14 < n20; ++n14) {
            if (this.barDoneFlags[n14] || this.barDeletedFlags[n14]) continue;
            this.barDoneFlags[n14] = true;
            n21 = n14;
            for (n22 = n21 + 1; n22 < n20; ++n22) {
                if (this.barDoneFlags[n22] || this.barDeletedFlags[n22]) continue;
                n13 = this.barX0s[n21];
                n12 = n13 + this.barPhysicalPixelWidths[n21] - 1;
                n11 = this.barX0s[n22];
                n10 = n11 + this.barPhysicalPixelWidths[n22] - 1;
                if (n11 > n12 || n10 < n12) continue;
                if (this.barPowers[n21] > this.barPowers[n22]) {
                    n11 = n12 + 1;
                    n9 = n10 - n11 + 1;
                    this.barX0s[n22] = n11;
                    this.barPhysicalPixelWidths[n22] = n9;
                    if (n9 >= 1) continue;
                    this.barDeletedFlags[n22] = true;
                    continue;
                }
                n12 = n11 - 1;
                this.barPhysicalPixelWidths[n21] = n9 = n12 - n13 + 1;
                if (n9 < 1) {
                    this.barDeletedFlags[n21] = true;
                }
                n21 = n22;
            }
        }
        for (n14 = 0; n14 < this.xPts.length; ++n14) {
            this.xPts[n14] = Integer.MIN_VALUE;
        }
        n14 = this.barNums[0];
        n21 = this.settings.isRelative() ? uMTSMeasurement.getIntegerReadingValue(14) : uMTSMeasurement.getAbsCdpTraceThreshold();
        for (n22 = 0; n22 < n20; ++n22) {
            n13 = this.barNums[n22];
            n12 = this.barPowers[n22];
            n11 = uMTSMeasurement.isBarActive(n13) ? 1 : 0;
            n10 = uMTSMeasurement.getChannelNumberForBar(n13);
            n9 = this.barWidths[n22];
            n8 = this.barWidthSums[n22];
            n7 = this.barX0s[n22];
            n6 = this.barPhysicalPixelWidths[n22];
            n5 = (n12 - n17) * n4 / n18;
            this.xPts[n14 + n22] = n7 + n6 / 2;
            this.yPts[n14 + n22] = n5;
            if (this.barDeletedFlags[n22]) continue;
            Color color = this.controlChannelBarChartModel.getColorForChannelType(uMTSMeasurement.getChannelType(n13));
            if (n11 != 0 && bl) {
                int n24 = uMTSMeasurement.getSpreadFactor(n13);
                int n25 = n8 - n9;
                this.drawWalshCode(graphics, n25, n7, 0, n4, n6, n24 + "(" + n10 + ")");
            }
            graphics.setColor(color);
            graphics.fillRect(n7, n5, n6, n4 - n5);
        }
        graphics.translate(-n, -n2);
        this.drawThresholdLine(graphics, n21, n, n2, n3, n4);
        if (this.drawLocationLabels) {
            this.paintLocationLabels(graphics, n, n2, n3, n4, this.startSlot, this.endSlot);
        }
        graphics.translate(n, n2);
        this.drawMarkers(graphics);
        graphics.translate(-n, -n2);
    }

    private void drawMarkers(Graphics graphics) {
        Marker[] markerArray = this.getMarkers();
        if (markerArray == null) {
            return;
        }
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i].paint(this, graphics, this.xPts, this.yPts);
        }
    }

    private void fillNice3DRect(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(color.darker().darker());
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.setColor(color.brighter().brighter());
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
        graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
    }

    protected String getUnits() {
        return this.controlChannelBarChartModel.getValueUnits();
    }

    public int getChannelLeftX(int n) {
        return this.paintX1 + this.getChannelRelativeXPositionTimes2(n) / this.zoomOutFactor;
    }

    public int getChannelRightX(int n) {
        return this.paintX1 + (this.getChannelRelativeXPositionTimes2(n) + this.getUnitBarWidth() - 1) / this.zoomOutFactor;
    }

    public int getPaintTop() {
        return this.paintY1;
    }

    public int getPaintBottom() {
        return this.paintY1 + this.paintH;
    }

    private int getChannelRelativeXPositionTimes2(int n) {
        int n2 = n - this.startSlot;
        return n2 * this.getUnitBarWidth() + n2 * this.getSlotSpacing();
    }

    protected Font getXAxisFont() {
        return this.walshFont;
    }

    protected int getXAxisRows() {
        return this.isLabelBars() ? 3 : 0;
    }

    protected int getBottomSpace() {
        return this.drawLocationLabels ? 11 : super.getBottomSpace();
    }

    protected int getSlotCount() {
        return (this.endSlot - this.startSlot + 1) / this.zoomOutFactor;
    }

    protected int getSlotSpacing() {
        return this.slotSpacing;
    }

    public void setSlotSpacing(int n) {
        this.slotSpacing = n;
    }

    private void paintLocationLabels(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        graphics.setFont(new Font("SansSerif", 0, 9));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n9 = n2 + n4 + 11 - 2;
        this.fillNice3DRect(graphics, new Color(160, 160, 224), n, n2 + n4, n3, 11);
        int n10 = n6 - n5 + 1;
        if (this.zoomStart - this.zoomEnd != 0) {
            n8 = n + (this.zoomStart - n5) * n3 / n10;
            n7 = n + (this.zoomEnd - this.zoomStart - n5) * n3 / n10;
            this.fillNice3DRect(graphics, Color.cyan, n8, n2 + n4 + 1, n7, 9);
        }
        graphics.setColor(Color.black);
        n8 = 0;
        n7 = 1;
        int n11 = n5;
        while (n8 == 0) {
            if (n11 >= n6) {
                n8 = 1;
                n11 = n6;
            }
            String string = Integer.toString(n11);
            int n12 = n + (n11 - n5) * n3 / n10;
            graphics.drawLine(n12, n2 + n4, n12, n2 + n4 - 3);
            int n13 = fontMetrics.stringWidth(string);
            int n14 = n12 - n13 / 2;
            if (n14 < n) {
                n14 = n + 2;
            } else if (n14 + n13 > n + n3) {
                n14 = n + n3 - n13;
            }
            if (n8 != 0 || n7 != 0) {
                graphics.drawString(string, n14, n9);
            }
            if (n3 <= 128) {
                n7 ^= 1;
            }
            n11 += 64;
        }
    }

    protected void showLimits(Graphics graphics, int n, int n2) {
        this.analyzer.setPassFailLabel();
    }
}

