/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.peakSearch.ActivityFinder;
import elgato.infrastructure.peakSearch.DiscreteActivityFinder;
import elgato.infrastructure.peakSearch.DiscretePeakFinder;
import elgato.infrastructure.peakSearch.PeakFinder;
import elgato.infrastructure.readings.BooleanReading;
import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.LongReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.readings.ShortArrayReading;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.measurement.umts.UMTSUnpacker;
import java.io.DataInput;
import java.io.IOException;
import java.util.Vector;

public class UMTSMeasurement
extends TraceMeasurement {
    static final long serialVersionUID = 3981275933654440537L;
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$umts$UMTSMeasurement == null ? (class$elgato$measurement$umts$UMTSMeasurement = UMTSMeasurement.class$("elgato.measurement.umts.UMTSMeasurement")) : class$elgato$measurement$umts$UMTSMeasurement);
    private static final Queue pool = new Queue(3);
    public static final int NUM_CHANNELS = 512;
    private static boolean VERIFY = "true".equals(System.getProperty("UMTSMeasurement.verify"));
    public static final int SCRAMBLING_CODE = 0;
    public static final int FREQUENCY_ERROR = 1;
    public static final int CHANNEL_POWER = 2;
    public static final int CDP_VALID = 3;
    public static final int EVM = 4;
    public static final int PCDE = 5;
    public static final int CARRIER_FEEDTHROUGH = 6;
    public static final int NOISE_FLOOR = 7;
    public static final int CPICH = 8;
    public static final int DIFF_PICH_POWER = 9;
    public static final int DIFF_PSCH_POWER = 10;
    public static final int DIFF_SSCH_POWER = 11;
    public static final int DIFF_PCCPCH_POWER = 12;
    public static final int DIFF_SCCPCH_POWER = 13;
    public static final int CDP_TRACE_THRESHOLD = 14;
    public static final int NUM_BARS = 15;
    public static final int CDP_TRACE = 16;
    public static final int CDP_SPREAD_FACTORS = 17;
    public static final int CDP_CHANNEL_NUMBERS = 18;
    public static final int ACTUATOR_ID_BASE = 19;
    public static final int FREQUENCY = 19;
    public static final int MANUAL_SCRAMBLING_CODE = 20;
    public static final int AUTO_SCRAMBLING_CODE_SEARCH = 21;
    public static final int SPEED_OF_THE_MEASUREMENT = 22;
    public static final int THRESHOLD_OFFSET = 23;
    public static final int THRESHOLD_OFFSET_LEVEL = 24;
    public static final int AUTO_THRESHOLD = 25;
    public static final int ATTENUATION = 26;
    public static final int AVERAGING_STATE = 27;
    public static final int NUM_AVERAGES = 28;
    public static final int SCCPCH_CH = 29;
    public static final int PICH_CH = 30;
    public static final int SCCPCH_SF = 31;
    public static final int SCCPCH_ENABLED = 32;
    public static final int PICH_ENABLED = 33;
    public static final int AVERAGE_COUNT = 34;
    public static final int METRICS_ENABLED = 35;
    public static final int HSDPA_STATE = 36;
    public static final int IFEQ_STATUS = 37;
    public static final int EVM_MODE = 38;
    public static final int CDP_POWER = 39;
    public static final int ACTUATOR_FREQUENCY = 0;
    public static final int ACTUATOR_MANUAL_SCRAMBLING_CODE = 1;
    public static final int ACTUATOR_AUTO_SCRAMBLING_CODE_SEARCH = 2;
    public static final int ACTUATOR_SPEED_OF_THE_MEASUREMENT = 3;
    public static final int ACTUATOR_THRESHOLD_OFFSET = 4;
    public static final int ACTUATOR_THRESHOLD_OFFSET_LEVEL = 5;
    public static final int ACTUATOR_AUTO_THRESHOLD = 6;
    public static final int ACTUATOR_ATTENUATION = 7;
    public static final int ACTUATOR_AVERAGING_STATE = 8;
    public static final int ACTUATOR_NUM_AVERAGES = 9;
    public static final int ACTUATOR_SCCPCH_CH = 10;
    public static final int ACTUATOR_PICH_CH = 11;
    public static final int ACTUATOR_SCCPCH_SF = 12;
    public static final int ACTUATOR_SCCPCH_ENABLED = 13;
    public static final int ACTUATOR_PICH_ENABLED = 14;
    public static final int ACTUATOR_METRICS_ENABLED = 16;
    private Reading[] readings;
    private final IntegerReading scramblingCode = new IntegerReading();
    private final IntegerReading frequencyError = new IntegerReading();
    private final IntegerReading channelPower = new IntegerReading();
    private final IntegerReading cdpPower = new IntegerReading();
    private final BooleanReading cdpValid = new BooleanReading();
    private final IntegerReading evm = new IntegerReading();
    private final IntegerReading pcde = new IntegerReading();
    private final IntegerReading carrierFeedthrough = new IntegerReading();
    private final IntegerReading noiseFloor = new IntegerReading();
    private final IntegerReading cpich = new IntegerReading();
    private final IntegerReading diffPICHPower = new IntegerReading();
    private final IntegerReading diffPSCHPower = new IntegerReading();
    private final IntegerReading diffSSCHPower = new IntegerReading();
    private final IntegerReading diffPCCPCHPower = new IntegerReading();
    private final IntegerReading diffSCCPCHPower = new IntegerReading();
    private final IntegerReading cdpTraceThreshold = new IntegerReading();
    private final IntegerReading numBars = new IntegerReading();
    private final IntegerArrayReading cdpTrace = new IntegerArrayReading(512);
    private final ShortArrayReading cdpSpreadFactors = new ShortArrayReading(512);
    private final ShortArrayReading cdpChannelNumbers = new ShortArrayReading(512);
    private final LongReading freq = new LongReading();
    private final IntegerReading manualScrambingCode = new IntegerReading();
    private final IntegerReading autoScramblingCodeSearch = new IntegerReading();
    private final IntegerReading speedOfTheMeasurement = new IntegerReading();
    private final IntegerReading thresholdOffset = new IntegerReading();
    private final IntegerReading thresholdOffsetLevel = new IntegerReading();
    private final IntegerReading autoThreshold = new IntegerReading();
    private final IntegerReading attenuation = new IntegerReading();
    private final IntegerReading averagingState = new IntegerReading();
    private final IntegerReading numAverages = new IntegerReading();
    private final IntegerReading sccpchCh = new IntegerReading();
    private final IntegerReading pichCh = new IntegerReading();
    private final IntegerReading sccpchSf = new IntegerReading();
    private final BooleanReading sccpchEnabled = new BooleanReading();
    private final BooleanReading pichEnabled = new BooleanReading();
    private final IntegerReading averageCount = new IntegerReading();
    private final BooleanReading metricsEnabled = new BooleanReading();
    private final BooleanReading hsdpa = new BooleanReading();
    private final IntegerReading ifEqStatus = new IntegerReading();
    private final IntegerReading evmMode = new IntegerReading();
    static /* synthetic */ Class class$elgato$measurement$umts$UMTSMeasurement;

    protected Reading[] getUMTSSensorReadings() {
        return new Reading[]{this.scramblingCode, this.frequencyError, this.channelPower, this.cdpValid, this.evm, this.pcde, this.carrierFeedthrough, this.noiseFloor, this.cpich, this.diffPICHPower, this.diffPSCHPower, this.diffSSCHPower, this.diffPCCPCHPower, this.diffSCCPCHPower, this.cdpTraceThreshold, this.numBars, this.cdpTrace, this.cdpSpreadFactors, this.cdpChannelNumbers};
    }

    protected Reading[] getUMTSActuatorReadings() {
        return new Reading[]{this.freq, this.manualScrambingCode, this.autoScramblingCodeSearch, this.speedOfTheMeasurement, this.thresholdOffset, this.thresholdOffsetLevel, this.autoThreshold, this.attenuation, this.averagingState, this.numAverages, this.sccpchCh, this.pichCh, this.sccpchSf, this.sccpchEnabled, this.pichEnabled};
    }

    protected Reading[] getUMTSAddedReadingsGroupA() {
        return new Reading[]{this.averageCount, this.metricsEnabled, this.hsdpa, this.ifEqStatus, this.evmMode, this.cdpPower};
    }

    UMTSMeasurement() {
        this.readings = this.createReadings();
    }

    public Reading[] createReadings() {
        int n = this.getUMTSSensorReadings().length;
        int n2 = this.getUMTSActuatorReadings().length;
        int n3 = this.getUMTSAddedReadingsGroupA().length;
        Reading[] readingArray = new Reading[n + n2 + n3];
        System.arraycopy(this.getUMTSSensorReadings(), 0, readingArray, 0, n);
        System.arraycopy(this.getUMTSActuatorReadings(), 0, readingArray, n, n2);
        System.arraycopy(this.getUMTSAddedReadingsGroupA(), 0, readingArray, n + n2, n3);
        return readingArray;
    }

    protected Reading[] getReadings() {
        return this.readings;
    }

    public static UMTSMeasurement unpack(DataInput dataInput) throws IOException {
        UMTSUnpacker uMTSUnpacker = UMTSUnpacker.instance();
        UMTSMeasurement uMTSMeasurement = UMTSMeasurement.create();
        uMTSMeasurement = uMTSUnpacker.unpackMeasurement(uMTSMeasurement, dataInput);
        if (VERIFY) {
            uMTSMeasurement.verify();
        }
        return uMTSMeasurement;
    }

    private static UMTSMeasurement create() {
        UMTSMeasurement uMTSMeasurement = (UMTSMeasurement)pool.dequeue();
        if (uMTSMeasurement == null) {
            uMTSMeasurement = new UMTSMeasurement();
        }
        return uMTSMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public int getTotalNumberOfChannels() {
        return 512;
    }

    public int getNumBars() {
        return this.numBars.intValue();
    }

    public int getRelBarPower(int n) {
        return this.cdpTrace.getTrace()[n];
    }

    public int getAbsBarPower(int n) {
        return this.convertToAbsolutePower(this.getRelBarPower(n));
    }

    public int getBarWidth(int n) {
        return 512 / this.getSpreadFactor(n);
    }

    public int getSpreadFactor(int n) {
        return this.cdpSpreadFactors.getTrace()[n] & 0xFFF;
    }

    public boolean isBarActive(int n) {
        return (this.cdpSpreadFactors.getTrace()[n] & 0xF000) >> 12 != 0;
    }

    public int getChannelType(int n) {
        return (this.cdpSpreadFactors.getTrace()[n] & 0xF000) >> 12;
    }

    public String getLabelForChannel(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = Text.CPICH;
                break;
            }
            case 2: {
                string = Text.P_CCPCH;
                break;
            }
            case 3: {
                string = Text.S_CCPCH;
                break;
            }
            case 4: {
                string = Text.PICH;
                break;
            }
            case 5: {
                string = Text.Traffic;
                break;
            }
            case 6: {
                string = Text.HS_SCCH;
                break;
            }
            case 7: {
                string = Text.HS_PDSCH_leftbanana_QPSK_rightbanana;
                break;
            }
            case 8: {
                string = Text.HS_PDSCH_leftbanana_16Q_rightbanana;
                break;
            }
            case 0: {
                string = Text.Noise;
                break;
            }
            default: {
                string = Text.Unknown;
            }
        }
        return string;
    }

    public int getChannelNumberForBar(int n) {
        return this.cdpChannelNumbers.getTrace()[n];
    }

    public Vector getActiveCodeChannels() {
        Vector<String[]> vector = new Vector<String[]>();
        for (int i = 0; i < this.getNumBars(); ++i) {
            if (!this.isBarActive(i)) continue;
            String[] stringArray = new String[]{String.valueOf(this.getSpreadFactor(i)) + "(" + String.valueOf(this.getChannelNumberForBar(i)) + ")", this.getLabelForChannel(this.getChannelType(i)), UIHelper.formatFixed(this.getRelBarPower(i), 1)};
            vector.addElement(stringArray);
        }
        return vector;
    }

    public int getAttenuation() {
        return this.attenuation.intValue();
    }

    public int getFreqError() {
        return this.frequencyError.intValue();
    }

    public int getEvm() {
        return this.evm.intValue();
    }

    public int getPcde() {
        return this.pcde.intValue();
    }

    public int getCpich() {
        return this.cpich.intValue();
    }

    public int getChannelPower() {
        return this.channelPower.intValue();
    }

    public int getCdpPower() {
        return this.cdpPower.intValue();
    }

    public int findChannel(int n, int n2) {
        int n3 = this.getNumBars();
        for (int i = 0; i < n3; ++i) {
            if (this.getChannelNumberForBar(i) != n2 || this.getSpreadFactor(i) != n) continue;
            return i;
        }
        return -1;
    }

    public int getAbsCdpTraceThreshold() {
        return this.convertToAbsolutePower(this.cdpTraceThreshold.intValue());
    }

    private int convertToAbsolutePower(int n) {
        return this.cdpPower.intValue() + n;
    }

    public int[] getTrace() {
        return this.cdpTrace.getTrace();
    }

    public int[] getActivityTrace() {
        int n = this.getNumBars();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.isBarActive(i) ? 1 : 0;
        }
        return nArray;
    }

    public long getTraceStartValue() {
        return 0L;
    }

    public long getTraceStopValue() {
        return 511L;
    }

    public int getIntegerReadingValue(int n) {
        return this.getReadings()[n].intValue();
    }

    public boolean getBooleanReadingValue(int n) {
        return this.getReadings()[n].booleanValue();
    }

    public long getLongReadingValue(int n) {
        return this.getReadings()[n].longValue();
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        throw new RuntimeException("Not implemented");
    }

    public double getDoubleReadingValue(int n) {
        throw new RuntimeException("Not implemented");
    }

    public float getFloatReadingValue(int n) {
        throw new RuntimeException("Not implemented");
    }

    public int getIndexForXValue(long l) {
        int n = (int)l;
        int n2 = this.numBars.intValue();
        int[] nArray = this.cdpChannelNumbers.getTrace();
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            int n4 = this.getSpreadFactor(i);
            int n5 = 512 / n4;
            int n6 = n3 * n5;
            int n7 = n6 + n5;
            if (n6 > n || n >= n7) continue;
            return i;
        }
        return -1;
    }

    public int linearizeXValue(int n) {
        int n2 = 0;
        int n3 = this.numBars.intValue();
        if (n > n3) {
            return Integer.MIN_VALUE;
        }
        for (int i = 0; i < n; ++i) {
            n2 += this.getBarWidth(i);
        }
        return n2 + this.getBarWidth(n) / 2;
    }

    public long getXValueForIndex(int n) {
        int n2 = this.numBars.intValue();
        if (n < 0 || n >= n2) {
            return Integer.MIN_VALUE;
        }
        return this.cdpChannelNumbers.getTrace()[n] * (512 / this.getSpreadFactor(n));
    }

    public PeakFinder createPeakFinder() {
        return new DiscretePeakFinder(512);
    }

    public ActivityFinder createActivityFinder() {
        return new DiscreteActivityFinder(512);
    }

    public String getMeasurementTitle() {
        boolean bl = MeasurementFactory.instance().optionAvailable("hsdpaAn");
        if (bl && this.hsdpa.booleanValue()) {
            return Text.W_dash_CDMA_leftBanana_w_slash_HSDPA_rightBanana_;
        }
        return Text.W_dash_CDMA_;
    }

    boolean verify() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.dumpify(stringBuffer);
        if (!bl) {
            logger.error("Invalid measurement:\n" + stringBuffer);
        }
        return bl;
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        this.dumpify(stringBuffer);
        return stringBuffer.toString();
    }

    private boolean dumpify(StringBuffer stringBuffer) {
        int n;
        int n2;
        boolean bl = true;
        stringBuffer.append("UMTS Measurement\n");
        int n3 = this.numBars.intValue();
        stringBuffer.append("numBars=" + n3 + "\n");
        int n4 = 0;
        for (int i = 0; i < this.getNumBars(); ++i) {
            n4 += this.getBarWidth(i);
        }
        if (n4 != 512) {
            bl = false;
            stringBuffer.append("ERR:sum(widths)=" + n4 + "\n");
        }
        int[] nArray = new int[512];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = -1;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            n = this.getChannelNumberForBar(n2);
            int n6 = this.getSpreadFactor(n2);
            int n7 = this.getBarWidth(n2);
            int n8 = this.getRelBarPower(n2);
            stringBuffer.append("bar " + n2 + ":" + " ch=" + n + " sf=" + n6 + " w=" + n7 + " pwr=" + n8 + "  ");
            if (n < 0) {
                bl = false;
                stringBuffer.append(" ERR:ch<0");
            }
            if (n >= n6) {
                bl = false;
                stringBuffer.append(" ERR:ch>=sf");
            }
            if (n6 < 1) {
                bl = false;
                stringBuffer.append(" ERR:sf<1");
            }
            if (n6 > 512) {
                bl = false;
                stringBuffer.append(" ERR:sf>512");
            }
            int n9 = n * n7;
            Vector<Integer> vector = new Vector<Integer>();
            for (n5 = n9; n5 < n9 + n7; ++n5) {
                if (nArray[n5] != -1) {
                    vector.addElement(new Integer(nArray[n5]));
                    continue;
                }
                nArray[n5] = n2;
            }
            if (vector.size() != 0) {
                for (n5 = 0; n5 < vector.size(); ++n5) {
                    bl = false;
                    Integer n10 = (Integer)vector.elementAt(n5);
                    stringBuffer.append(" ERR:overlap=" + n10);
                }
            }
            stringBuffer.append("\n");
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n != -1) continue;
            bl = false;
            stringBuffer.append("\nERR:unusedlocation=" + n2);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

