/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.measurement.umts.UMTSMeasurement;
import elgato.measurement.umts.UMTSMeasurementSettings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Random;

public class UMTSMeasurementGenerator
extends MeasurementGenerator {
    public int minPower = -40000;
    public int maxPower = 0;
    public int unknownFudgeAmount = 7000;
    private Random random = new Random();
    public int cdpTraceThreshold;
    public int channelPower;
    public int numBars;
    public int scramblingCode;
    public int[] cdpTrace = new int[512];
    public int[] cdpSpreadFactors = new int[512];
    public int[] cdpChannelNumbers = new int[512];
    private Hashtable readingValues = new Hashtable();

    public void putReadingValue(int n, int n2) {
        this.readingValues.put(new Integer(n), new Integer(n2));
    }

    protected void writePayload(DataOutput dataOutput) throws IOException {
        UMTSMeasurementSettings uMTSMeasurementSettings = UMTSMeasurementSettings.instance();
        this.initData();
        for (int i = 0; i <= 13; ++i) {
            if (i == 2) {
                dataOutput.writeInt(this.channelPower);
                continue;
            }
            if (i == 0) {
                dataOutput.writeInt(this.scramblingCode);
                continue;
            }
            if (i == 1) {
                this.writeReadingValue(1000, dataOutput);
                continue;
            }
            this.writeReadingValue(i, dataOutput);
        }
        dataOutput.writeInt(this.cdpTraceThreshold);
        dataOutput.writeInt(this.numBars);
        this.writeIntArray(dataOutput, this.cdpTrace);
        this.writeShortArray(dataOutput, this.cdpSpreadFactors);
        this.writeShortArray(dataOutput, this.cdpChannelNumbers);
        this.writeOverAirSensorChunk(dataOutput);
        long l = uMTSMeasurementSettings.getCenterFreq().longValue();
        dataOutput.writeInt((int)(l / 1000L));
        dataOutput.writeInt((int)(l % 1000L));
        this.putReadingValue(30, uMTSMeasurementSettings.getPICHLocation().intValue());
        this.putReadingValue(29, uMTSMeasurementSettings.getSCCPCHLocation().intValue());
        this.putReadingValue(31, uMTSMeasurementSettings.getSCCPCHSpreadFactor().intValue());
        this.putReadingValue(32, uMTSMeasurementSettings.getSCCPCHEnabled().intValue());
        this.putReadingValue(33, uMTSMeasurementSettings.getPICHEnabled().intValue());
        for (int i = 20; i <= 33; ++i) {
            if (i == 27) {
                dataOutput.writeInt(uMTSMeasurementSettings.getAveraging().intValue());
                continue;
            }
            if (i == 28) {
                dataOutput.writeInt(uMTSMeasurementSettings.getNumAverages().intValue());
                continue;
            }
            this.writeReadingValue(i, dataOutput);
        }
        this.writeOverAirActuatorChunk(dataOutput);
        this.writeAddedReadingsGroupA(dataOutput);
    }

    private void writeReadingValue(int n, DataOutput dataOutput) throws IOException {
        Integer n2 = (Integer)this.readingValues.get(new Integer(n));
        if (n2 != null) {
            dataOutput.writeInt(n2);
        } else {
            dataOutput.writeInt(n);
        }
    }

    protected void initData() {
        UMTSMeasurementSettings uMTSMeasurementSettings = UMTSMeasurementSettings.instance();
        this.scramblingCode = uMTSMeasurementSettings.getScramblingCodeAuto().booleanValue() ? this.nextInt(512) : uMTSMeasurementSettings.getScramblingCode().intValue();
        this.cdpTraceThreshold = this.minPower + this.nextInt((this.maxPower - this.minPower) / 2);
        this.channelPower = this.maxPower + 1100 + this.nextInt(2000);
        int n = 0;
        int n2 = 0;
        while (n < 512) {
            int n3;
            int n4;
            boolean bl;
            boolean bl2 = bl = this.nextInt(100) < 25;
            if (bl) {
                n4 = 1 << this.nextInt(6);
                n3 = this.nextInt(this.maxPower - this.cdpTraceThreshold) + this.cdpTraceThreshold;
            } else {
                n4 = 1;
                n3 = this.nextInt(this.cdpTraceThreshold + 1000 - this.minPower) + this.minPower;
            }
            if (n3 < this.cdpTraceThreshold + this.unknownFudgeAmount) {
                bl = false;
            }
            if (n / 2 == 0) {
                bl = true;
                n3 = this.maxPower - 11000 + this.nextInt(1000);
                n4 = 2;
            } else if (n / 2 == 1) {
                bl = true;
                n3 = this.maxPower - 12000 + this.nextInt(2500);
                n4 = 2;
            } else if (n / 2 == 2) {
                bl = false;
                n4 = 2;
            } else if (n / 8 == 6) {
                bl = true;
                n3 = this.maxPower - 14000 + this.nextInt(1024);
                n4 = 8;
            } else if (n / 8 < 6) {
                n4 = 1;
            } else if (n / 2 == 32) {
                bl = true;
                n3 = this.maxPower - 15000 + this.nextInt(4000);
                n4 = 2;
            } else if (n / 2 == 34) {
                bl = true;
                n3 = this.maxPower - 20000 + this.nextInt(1000);
                n4 = 2;
            }
            while (n + n4 > 512 || n % n4 != 0) {
                if (n4 == 1) {
                    throw new RuntimeException("Oh, no! I can't make this channel work! widthSum=" + n);
                }
                n4 >>= 1;
            }
            this.cdpTrace[n2] = n3;
            this.cdpChannelNumbers[n2] = n / n4;
            this.cdpSpreadFactors[n2] = 512 / n4;
            n += n4;
            ++n2;
        }
        this.numBars = n2;
        this.putReadingValue(12, this.nextInt(6) == 0 ? -333000 : -this.nextInt(3000) - 1000);
        this.putReadingValue(13, this.nextInt(5) == 0 ? -333000 : -this.nextInt(8000) - 1000);
        this.putReadingValue(9, this.nextInt(3) == 0 ? -333000 : -this.nextInt(7000) - 2000);
        this.putReadingValue(10, this.nextInt(3) == 0 ? -333000 : -this.nextInt(8000) - 8000);
        this.putReadingValue(11, this.nextInt(3) == 0 ? -333000 : -this.nextInt(8000) - 8000);
    }

    private int nextInt(int n) {
        return (this.random.nextInt() & Integer.MAX_VALUE) % n;
    }

    private void writeIntArray(DataOutput dataOutput, int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            dataOutput.writeInt(nArray[i]);
        }
    }

    private void writeShortArray(DataOutput dataOutput, int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            dataOutput.writeShort(nArray[i]);
        }
    }

    void writeOverAirActuatorChunk(DataOutput dataOutput) throws IOException {
    }

    void writeOverAirSensorChunk(DataOutput dataOutput) throws IOException {
    }

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return UMTSMeasurement.unpack(dataInput);
    }

    protected void writeAddedReadingsGroupA(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(12345);
        dataOutput.writeInt(1);
        dataOutput.writeInt(1);
        dataOutput.writeInt(1);
        dataOutput.writeInt(1);
        this.writeReadingValue(39, dataOutput);
    }
}

