/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.actuators.TrimodeActuatorButton;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.marker.ActivityMarkerButtonFactory;
import elgato.infrastructure.marker.MarkerButtonFactory;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.ActionButton;
import elgato.infrastructure.menu.FrequencyChannelButtonFactory;
import elgato.infrastructure.menu.LevelButtonFactory;
import elgato.infrastructure.menu.MeasurementMenuMgr;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.menu.TimeFreqRefButtonFactory;
import elgato.infrastructure.units.PrefixedUnitsConversion;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.umts.CommonUMTSMeasurementSettings;
import elgato.measurement.umts.UMTSAnalyzer;
import elgato.measurement.umts.UMTSScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class UMTSMenuMgr
extends MeasurementMenuMgr {
    protected static final Logger logger = LogManager.getLogger(class$elgato$measurement$cdma$CdmaMenuMgr == null ? (class$elgato$measurement$cdma$CdmaMenuMgr = UMTSMenuMgr.class$("elgato.measurement.cdma.CdmaMenuMgr")) : class$elgato$measurement$cdma$CdmaMenuMgr);
    protected final UMTSAnalyzer analyzer;
    final CommonUMTSMeasurementSettings settings;
    private Menu freqChanMenu;
    private Menu displayMenu;
    private Menu limitsMenu;
    protected Menu more1of2SetupMenu;
    protected Menu more2of2SetupMenu;
    protected SubMenuButton limitsMenuButton;
    private SubMenuButton codogramSubMenu;
    private MenuItem positionButton;
    private ActionButton widthButton;
    private ActivityMarkerButtonFactory markerButtonFactory;
    private MultiStateActuatorButton metricsButton;
    private ValueListener viewModeListener = new ValueListener(){
        private String listenerName = ".viewModeListener";
        private String baseName = null;

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = UMTSMenuMgr.this.scn.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            EventDispatchThread.runOnEventThread("viewModeListener", new Runnable(this, valueInterface){
                private final /* synthetic */ ValueInterface val$value;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                    this.val$value = valueInterface;
                }

                public void run() {
                    boolean bl = this.val$value.intValue() == 0;
                    UMTSMenuMgr.access$300(1.access$100(this.this$1)).setEnabled(bl &= UMTSMenuMgr.access$200(1.access$100(this.this$1)).getItems()[0].isEnabled());
                    UMTSMenuMgr.access$400(1.access$100(this.this$1)).setEnabled(bl);
                    if (bl) {
                        UMTSMenuMgr.access$200(1.access$100(this.this$1)).setDefaultItem(1);
                    } else {
                        UMTSMenuMgr.access$200(1.access$100(this.this$1)).setDefaultItem(-1);
                    }
                }
            });
            UMTSMenuMgr.this.scn.getScreenManager().getRightMenuPanel().repaint();
        }

        static /* synthetic */ UMTSMenuMgr access$100(1 var0) {
            return var0.UMTSMenuMgr.this;
        }
    };
    private ActionListener focusPositionButton = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ScreenManager screenManager = UMTSMenuMgr.this.scn.getScreenManager();
            MenuPanel menuPanel = screenManager.getRightMenuPanel();
            if (menuPanel.getMenuItems()[1] == UMTSMenuMgr.this.positionButton) {
                menuPanel.focusButton(UMTSMenuMgr.this.positionButton);
            }
        }
    };
    private Menu codogramMenu;
    private ValueListener codogramEnabledValueListener = new ValueListener(){
        private String listenerName = ".codogramEnabledValueListener";
        private String baseName = null;

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = UMTSMenuMgr.this.scn.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            boolean bl = valueInterface.booleanValue();
            MenuItem[] menuItemArray = UMTSMenuMgr.this.codogramMenu.getItems();
            for (int i = 1; i < menuItemArray.length && i != 6; ++i) {
                if (menuItemArray[i] == null) continue;
                menuItemArray[i].setEnabled(bl);
            }
            UMTSMenuMgr.this.displayMenu.getItems()[5].setEnabled(!bl);
            UMTSMenuMgr.this.viewModeListener.valueChanged(UMTSMenuMgr.this.settings.getViewMode().getSelectedValue());
            UMTSMenuMgr.this.scn.getScreenManager().getRightMenuPanel().repaint();
        }
    };
    private Menu activeCodeChTableMenu;
    private SubMenuButton activeCodeChTableSubMenu;
    private ValueListener activeCodeChTableEnabledListener = new ValueListener(){
        private String listenerName = ".activeCodeChTableEnabledListener";
        private String baseName = null;

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = UMTSMenuMgr.this.scn.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            boolean bl = valueInterface.booleanValue();
            MenuItem[] menuItemArray = UMTSMenuMgr.this.activeCodeChTableMenu.getItems();
            for (int i = 1; i < menuItemArray.length && i != 6; ++i) {
                if (menuItemArray[i] == null) continue;
                menuItemArray[i].setEnabled(bl);
            }
            UMTSMenuMgr.this.viewModeListener.valueChanged(UMTSMenuMgr.this.settings.getViewMode().getSelectedValue());
            UMTSMenuMgr.this.scn.getScreenManager().getRightMenuPanel().repaint();
        }
    };
    protected SubMenuButton sccpchButton;
    protected SubMenuButton pichButton;
    private Menu sccpchSubmenu;
    private Menu pichSubmenu;
    private ValueListener sccpchAndPICHUpdateListener = new ValueListener(){
        private String listenerName = ".sccpchAndPichUpdateListener";
        private String baseName = null;

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = UMTSMenuMgr.this.scn.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            UMTSMenuMgr.this.updateSCCPCHAndPICHSubtext();
        }
    };
    static /* synthetic */ Class class$elgato$measurement$cdma$CdmaMenuMgr;

    public UMTSMenuMgr(UMTSScreen uMTSScreen, CommonUMTSMeasurementSettings commonUMTSMeasurementSettings, UMTSAnalyzer uMTSAnalyzer) {
        super(uMTSScreen);
        this.settings = commonUMTSMeasurementSettings;
        this.analyzer = uMTSAnalyzer;
    }

    protected Menu buildLeftMenu() {
        return new Menu(this.getLeftMenuTitle(), new MenuItem[]{this.createFreqChanMenu(), this.createLevelMenu(), this.createDisplayMenu(), null, this.createAverageSweepButton(this.settings.getNumAverages(), this.settings.getAveraging()), this.createSetupMenu(), this.markerButtonFactory.getMenuButton()});
    }

    protected String getLeftMenuTitle() {
        boolean bl = MeasurementFactory.instance().optionAvailable("hsdpaAn");
        if (bl) {
            return Text.HSDPA_Anl_dot_;
        }
        return Text.W_dash_CDMA_Anl_dot_;
    }

    protected MultiStateActuatorButton createHsdpaButton() {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(this.settings.getHsdpa(), "hsdpa", this.scn.getListenerBaseName() + ".hsdpaButton");
        boolean bl = MeasurementFactory.instance().optionAvailable("hsdpaAn");
        if (!bl) {
            this.settings.getHsdpa().send(0);
        }
        multiStateActuatorButton.setEnabled(bl);
        return multiStateActuatorButton;
    }

    private MenuItem createFreqChanMenu() {
        this.freqChanMenu = new Menu(Text.Freq_slash_Chan, new MenuItem[]{new ActuatorEditor(this.settings.getCenterFreq(), this.scn.getContextString("frequencyChannel.cf"), this.scn.getListenerBaseName() + ".freqChanButton"), null, new TrimodeActuatorButton((ValueListInterface)this.settings.getScramblingCodeAuto(), this.scn.getContextString("frequencyChannel.sc"), this.settings.getScramblingCode(), this.scn.getListenerBaseName() + ".scramblingCodeButton"), null, TimeFreqRefButtonFactory.createTimeFreqRefButton(this.scn.getListenerBaseName()), FrequencyChannelButtonFactory.createChanStdSelectButton(this.scn.getContextString("chan.std"), this.scn.getListenerBaseName()), MeasurementMenuMgr.createFreqChanUnitsButton(this.scn.getListenerBaseName())}, 0);
        return new SimpleMenuButton(Text.Freq_slash_Chan + "/\n" + Text.Time_Ref, this.scn.getContextString("frequencyChannel"), this.freqChanMenu);
    }

    private MenuItem createLevelMenu() {
        return new SimpleMenuButton(Text.Level_slash_n_Location, "level", new Menu(Text.Level_slash_n_Location, new MenuItem[]{new MultiStateActuatorButton(this.settings.getReference(), this.scn.getContextString("ref.level"), this.scn.getListenerBaseName() + ".refLevelButton"), null, new ActuatorEditor(this.settings.getScaleDiv(), this.scn.getContextString("level.scaleDivision"), this.scn.getListenerBaseName() + ".scaleDivButton"), LevelButtonFactory.createGpsLocationButton(this.scn), null, null, MeasurementMenuMgr.createLossButton(DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), this.settings.getRFInLoss(), DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.scn.getContextString("rf.in.loss"), this.scn.getListenerBaseName() + ".RfInLossButton")}, 0));
    }

    protected SimpleMenuButton createDisplayMenu() {
        this.positionButton = new ActuatorEditor(this.settings.getPosition(), this.scn.getContextString("position"), this.scn.getListenerBaseName() + ".positionButton");
        this.widthButton = new MultiStateActuatorButton(this.settings.getWidth(), this.scn.getContextString("width"), this.scn.getListenerBaseName() + ".widthButton");
        this.metricsButton = new MultiStateActuatorButton(this.settings.getMetricsEnabled(), this.scn.getContextString("metrics.enabled"), this.scn.getListenerBaseName() + ".metricsButton");
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(this.settings.getViewMode(), this.scn.getContextString("view"), this.scn.getListenerBaseName() + ".viewToggleButton");
        multiStateActuatorButton.addActionListener(this.focusPositionButton);
        this.displayMenu = new Menu(Text.Display, new MenuItem[]{multiStateActuatorButton, this.positionButton, this.widthButton, this.createCodogramSubMenuButton(), this.createActiveCodeChTableSubMenuButton(), this.metricsButton});
        return new SimpleMenuButton(Text.Display, this.scn.getContextString("display"), this.displayMenu);
    }

    private SubMenuButton createCodogramSubMenuButton() {
        this.codogramSubMenu = new SubMenuButton(Text.Codogram, this.scn.getContextString("display"), this.createCodogramMenu(), true);
        this.codogramSubMenu.getCancelButton().setText(Text.Back);
        return this.codogramSubMenu;
    }

    public Menu createCodogramMenu() {
        this.codogramMenu = new Menu(Text.Codogram, new MenuItem[]{new MultiStateActuatorButton(this.settings.getCodogramEnabled(), this.scn.getContextString("codogram.enabled"), this.scn.getListenerBaseName() + ".codogramEnabledButton"), this.createResetCodogramButton("codogramResetMetrics"), new ActuatorEditor(this.settings.getSpectrogramCaptureInterval(), "codogramCaptureInterval", this.scn.getListenerBaseName() + ".captureIntervalButton"), null, new ActuatorSubMenuButton(this.settings.getCodogramPalette(), this.scn.getContextString("codogram.palette"), true, this.scn.getListenerBaseName() + ".codogramPaletteButton")});
        return this.codogramMenu;
    }

    private MenuItem createResetCodogramButton(String string) {
        return new PushButton(Text.Reset_n_Codogram, string, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UMTSMenuMgr.this.analyzer.clearCodogramHistory();
            }
        });
    }

    private SubMenuButton createActiveCodeChTableSubMenuButton() {
        this.activeCodeChTableSubMenu = new SubMenuButton(Text.Active_Code_n_Ch_Table, this.scn.getContextString("display"), this.createActiveCodeChTableMenu(), true);
        this.activeCodeChTableSubMenu.getCancelButton().setText(Text.Back);
        return this.activeCodeChTableSubMenu;
    }

    public Menu createActiveCodeChTableMenu() {
        this.activeCodeChTableMenu = new Menu(Text.Act_dot_Code_Tbl_dot_, new MenuItem[]{new MultiStateActuatorButton(this.settings.getActiveCodeChTableEnabled(), this.scn.getContextString("activeCodeChTable.enabled"), this.scn.getListenerBaseName() + ".activeCodeChTableEnabledButton"), this.createPageUpButton("activeCodeChTablePageUp"), this.createPageDownButton("activeCodeChTablePageDown"), this.createRowUpButton("activeCodeChTableRowUp"), this.createRowDownButton("activeCodeChTableRowDown")});
        return this.activeCodeChTableMenu;
    }

    private MenuItem createPageUpButton(String string) {
        return new PushButton(Text.Page_Up, string, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UMTSMenuMgr.this.analyzer.getActiveCodeChTable().pageUp();
            }
        });
    }

    private MenuItem createPageDownButton(String string) {
        return new PushButton(Text.Page_Down, string, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UMTSMenuMgr.this.analyzer.getActiveCodeChTable().pageDown();
            }
        });
    }

    private MenuItem createRowUpButton(String string) {
        return new PushButton(Text.Row_Up, string, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UMTSMenuMgr.this.analyzer.getActiveCodeChTable().rowUp();
            }
        });
    }

    private MenuItem createRowDownButton(String string) {
        return new PushButton(Text.Row_Down, string, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UMTSMenuMgr.this.analyzer.getActiveCodeChTable().rowDown();
            }
        });
    }

    protected SimpleMenuButton createSetupMenu() {
        this.sccpchSubmenu = new Menu(Text.S_CCPCH, new MenuItem[]{new MultiStateActuatorButton(this.settings.getSCCPCHEnabled(), "sccpch", this.scn.getListenerBaseName() + ".sccpchEnabledButton"), new ActuatorSubMenuButton(this.settings.getSCCPCHSpreadFactor(), "sccpch", false, this.scn.getListenerBaseName() + ".sccpchSfButton"), new ActuatorEditor(this.settings.getSCCPCHLocation(), "sccpch", this.scn.getListenerBaseName() + ".sccpchNumButton")});
        MenuItem[] menuItemArray = new MenuItem[3];
        menuItemArray[0] = new MultiStateActuatorButton(this.settings.getPICHEnabled(), "pich", this.scn.getListenerBaseName() + ".pichEnabledButton");
        ActuatorEditor actuatorEditor = new ActuatorEditor(Value.createValue(Text.Spread_n_Factor, 256), "pich", this.scn.getListenerBaseName() + ".pichSfButton");
        menuItemArray[1] = actuatorEditor;
        menuItemArray[2] = new ActuatorEditor(this.settings.getPICHLocation(), "pich", this.scn.getListenerBaseName() + ".pichNumButton");
        this.pichSubmenu = new Menu(Text.PICH, menuItemArray);
        actuatorEditor.setEnabled(false);
        this.sccpchButton = new SubMenuButton(Text.S_CCPCH, "sccpch", this.sccpchSubmenu, true);
        this.pichButton = new SubMenuButton(Text.PICH, "pich", this.pichSubmenu, true);
        this.updateSCCPCHAndPICHSubtext();
        this.sccpchButton.setCancelButtonTitle(Text.Back);
        this.pichButton.setCancelButtonTitle(Text.Back);
        this.createSetupMenus();
        return new SimpleMenuButton(Text.Setup, this.scn.getContextString("setup"), this.more1of2SetupMenu);
    }

    protected void createSetupMenus() {
        this.more1of2SetupMenu = new Menu(Text.Setup, new MenuItem[]{this.makeThresholdButton(), this.makeThresholdOffsetButton(), this.makeMeasTimeButton(), this.createHsdpaButton(), this.sccpchButton, this.pichButton, this.createMoreButton(Text.More_n_1_of_2)});
        this.more2of2SetupMenu = new Menu(Text.Setup, new MenuItem[]{this.createLimitsButton(), null, null, null, new MultiStateActuatorButton(this.settings.getEvmMode(), "", this.getListenerBaseName() + ".evmMode"), new MultiStateActuatorButton(this.settings.getEqStatus(), "", this.getListenerBaseName() + ".eqStatus"), this.createMore2Button(Text.More_n_2_of_2)});
    }

    protected PushButton createMoreButton(String string) {
        return new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UMTSMenuMgr.this.scn.getScreenManager().installRightMenu(UMTSMenuMgr.this.more2of2SetupMenu);
            }
        });
    }

    protected PushButton createMore2Button(String string) {
        return new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UMTSMenuMgr.this.scn.getScreenManager().installRightMenu(UMTSMenuMgr.this.more1of2SetupMenu);
            }
        });
    }

    protected SubMenuButton createLimitsButton() {
        this.limitsMenu = new Menu(Text.Limits, new MenuItem[]{this.createFreqErrorLimitsButton(), this.createEvmLimitsButton(), this.createPcdeLimitsButton(), this.createCpichLimitsButton(), null, null, null});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Limits, this.getContextString("Limits"), this.limitsMenu, true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        subMenuButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UMTSMenuMgr.this.settings.setAllLimits();
            }
        });
        return subMenuButton;
    }

    private MenuItem createFreqErrorLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Freq_Error_Limits, this.getContextString("freqErrorLimits"), new Menu(Text.Freq_Error, new MenuItem[]{this.createOnOffLimitsButton(0), new ActuatorEditor(this.settings.getFreqErrorUpperLimit(), this.getContextString("freqErrorLimits"), this.getListenerBaseName() + ".freqErrorULimits"), this.createFreqErrorLowerLimitButton()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createFreqErrorLowerLimitButton() {
        TrimodeActuatorButton trimodeActuatorButton = new TrimodeActuatorButton((ValueListInterface)this.settings.getFreqErrorLowerLimitMode(), this.getContextString("freqErrorLimits"), new ValueInterface[]{this.settings.getFreqErrorLowerLimit(), this.settings.getFreqErrorLowerLimit()}, this.getListenerBaseName() + ".freqErrorLLimits");
        trimodeActuatorButton.setReadOnlyValueIndex(0);
        return trimodeActuatorButton;
    }

    private MenuItem createEvmLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.EVM_Limits, this.getContextString("freqErrorLimits"), new Menu(Text.EVM, new MenuItem[]{this.createOnOffLimitsButton(1), new ActuatorEditor(this.settings.getEvmUpperLimit_QpskOnly(), this.getContextString("evmLimits"), this.getListenerBaseName() + ".evmULimit1"), this.createEvmUpperLimitButton_inclQam()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createEvmUpperLimitButton_inclQam() {
        ActuatorEditor actuatorEditor = new ActuatorEditor(this.settings.getEvmUpperLimit_inclQam(), this.getContextString("evmLimits"), this.getListenerBaseName() + ".evmULimit2");
        boolean bl = MeasurementFactory.instance().optionAvailable("hsdpaAn");
        actuatorEditor.setEnabled(bl);
        return actuatorEditor;
    }

    private MenuItem createPcdeLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.PCDE_Limits, this.getContextString("pcdeLimits"), new Menu(Text.PCDE, new MenuItem[]{this.createOnOffLimitsButton(2), new ActuatorEditor(this.settings.getPcdeUpperLimit(), this.getContextString("pcdeLimits"), this.getListenerBaseName() + ".pcdeULimits")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createCpichLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.CPICH_Limits, this.getContextString("cpichLimits"), new Menu(Text.CPICH, new MenuItem[]{this.createOnOffLimitsButton(3), new ActuatorEditor(this.settings.getCpichUpperLimit(), this.getContextString("cpichLimits"), this.getListenerBaseName() + ".cpichULimits"), new ActuatorEditor(this.settings.getCpichLowerLimit(), this.getContextString("cpichLimits"), this.getListenerBaseName() + ".cpichLLimits")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createOnOffLimitsButton(int n) {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(this.settings.limitsToggleAt(n), "", this.getListenerBaseName() + ".linOnOff");
        this.setSettingsShowLimits();
        multiStateActuatorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UMTSMenuMgr.this.setSettingsShowLimits();
                UMTSMenuMgr.this.settings.allowValidationNow();
            }
        });
        return multiStateActuatorButton;
    }

    public void setSettingsShowLimits() {
        this.analyzer.swapBottomPanel(this.settings.getLimitsSummaryState());
    }

    private void updateSCCPCHAndPICHSubtext() {
        this.sccpchButton.setSubText(this.makeChannelSetupButtonText(this.settings.getSCCPCHSpreadFactor().intValue(), this.settings.getSCCPCHLocation().intValue(), this.settings.getSCCPCHEnabled()));
        this.pichButton.setSubText(this.makeChannelSetupButtonText(256, this.settings.getPICHLocation().intValue(), this.settings.getPICHEnabled()));
    }

    private String makeChannelSetupButtonText(int n, int n2, ListActuator listActuator) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append('(').append(n2).append(')');
        stringBuffer.append('\n');
        if (listActuator.intValue() != 0) {
            stringBuffer.append(Text.Enabled);
        } else {
            stringBuffer.append(Text.Disabled);
        }
        return stringBuffer.toString();
    }

    TrimodeActuatorButton makeThresholdButton() {
        return new TrimodeActuatorButton((ValueListInterface)this.settings.getThresholdAuto(), this.scn.getContextString("thresholdLevel"), this.settings.getThresholdLevel(), this.scn.getListenerBaseName() + ".thresholdLevel");
    }

    ActuatorEditor makeThresholdOffsetButton() {
        return new ActuatorEditor(this.settings.getThresholdOffset(), this.scn.getContextString("thresholdOffset"), this.scn.getListenerBaseName() + ".thresholdOffset");
    }

    MultiStateActuatorButton makeMeasTimeButton() {
        return new MultiStateActuatorButton(this.settings.getSpeedOfTheMeasurement(), this.scn.getContextString("meas.time"), this.scn.getListenerBaseName() + ".measTimeButton");
    }

    public MarkerButtonFactory createMarkerMenuButton() {
        LongActuator longActuator = new LongActuator("", "", "");
        longActuator.setConversion(new PrefixedUnitsConversion(Text.Chan));
        this.markerButtonFactory = new ActivityMarkerButtonFactory((MeasurementScreen)this.scn, null, null, longActuator, false);
        return this.markerButtonFactory;
    }

    public void setupFreqChanUnitsListener() {
        this.setupFreqChanUnitsListener(this.freqChanMenu, 1);
    }

    public void prolog() {
        this.addValueListeners();
    }

    public void cleanup() {
        this.removeValueListeners();
        super.cleanup();
    }

    public void addValueListeners() {
        ListActuator listActuator = this.settings.getViewMode();
        listActuator.addValueListener(this.viewModeListener);
        this.viewModeListener.valueChanged(listActuator.getSelectedValue());
        this.setupFreqChanUnitsListener();
        this.settings.getSCCPCHEnabled().addValueListener(this.sccpchAndPICHUpdateListener);
        this.settings.getSCCPCHSpreadFactor().addValueListener(this.sccpchAndPICHUpdateListener);
        this.settings.getSCCPCHLocation().addValueListener(this.sccpchAndPICHUpdateListener);
        this.settings.getPICHEnabled().addValueListener(this.sccpchAndPICHUpdateListener);
        this.settings.getPICHLocation().addValueListener(this.sccpchAndPICHUpdateListener);
        this.settings.getCodogramEnabled().addValueListener(this.codogramEnabledValueListener);
        this.settings.getActiveCodeChTableEnabled().addValueListener(this.activeCodeChTableEnabledListener);
    }

    public void removeValueListeners() {
        this.settings.getViewMode().removeValueListener(this.viewModeListener);
        this.settings.getSCCPCHEnabled().removeValueListener(this.sccpchAndPICHUpdateListener);
        this.settings.getSCCPCHSpreadFactor().removeValueListener(this.sccpchAndPICHUpdateListener);
        this.settings.getSCCPCHLocation().removeValueListener(this.sccpchAndPICHUpdateListener);
        this.settings.getPICHEnabled().removeValueListener(this.sccpchAndPICHUpdateListener);
        this.settings.getPICHLocation().removeValueListener(this.sccpchAndPICHUpdateListener);
        this.settings.getCodogramEnabled().removeValueListener(this.codogramEnabledValueListener);
        this.settings.getActiveCodeChTableEnabled().removeValueListener(this.activeCodeChTableEnabledListener);
    }

    protected String getMeasurementName() {
        return "umtsAn";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ ActionButton access$400(UMTSMenuMgr uMTSMenuMgr) {
        return uMTSMenuMgr.widthButton;
    }
}

