/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.metrics.BasicMeasurementMetrics;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.measurement.umts.UMTSAnalyzer;
import elgato.measurement.umts.UMTSMeasurement;
import elgato.measurement.umts.UMTSMeasurementSettings;
import java.awt.Color;

class UMTSMetrics
extends BasicMeasurementMetrics {
    private UMTSAnalyzer analyzer;
    private NumberFieldStrategy freqStrategy;
    private NumberFieldStrategy evmStrategy;
    private NumberFieldStrategy dbStrategy;
    private BasicMeasurementMetrics.ReadingValueSource freqValueSource;
    private ValueSource freqErrorValueSource;
    private ValueSource evmValueSource;
    private ValueSource pcdeValueSource;
    private ValueSource carrFeedthruValueSource;
    private ValueSource cpichValueSource;

    protected ValueSource[][] createValueSources() {
        this.freqStrategy = FrequencyStrategy.createWithMaxDecimalPlaces(3);
        this.evmStrategy = new FixedPointNumberFieldStrategy(1, "%");
        this.dbStrategy = new DecibelStrategy(1, true);
        this.freqValueSource = new BasicMeasurementMetrics.ReadingValueSource(Text.Freq, this.freqStrategy, true, 19);
        this.freqErrorValueSource = this.createFreqErrorValueSource(this.freqStrategy);
        this.evmValueSource = this.createEvmValueSource(this.evmStrategy);
        this.pcdeValueSource = this.createPcdeValueSource(new DecibelStrategy(1));
        this.carrFeedthruValueSource = this.createCarrFeedthruValueSource(new FixedPointNumberFieldStrategy(1, "dBc"));
        this.cpichValueSource = this.createCpichValueSource(this.dbStrategy);
        ScramblingCodeValueSource scramblingCodeValueSource = new ScramblingCodeValueSource(Text.Scramble_Code, new NumberFieldStrategy(), true, 0);
        return new ValueSource[][]{{this.freqValueSource.setIgnoreValidFlag(true), this.freqErrorValueSource, scramblingCodeValueSource, new BasicMeasurementMetrics.ReadingValueSource(Text.Noise_Floor, new DecibelStrategy(1), true, 7), new BasicMeasurementMetrics.ReadingValueSource(Text.Threshold, new DecibelStrategy(1), true, 14)}, {this.evmValueSource, this.pcdeValueSource, this.carrFeedthruValueSource, new BasicMeasurementMetrics.ReadingValueSource(Text.Chan_Pwr, this.dbStrategy, true, 2).setIgnoreValidFlag(true), this.cpichValueSource}, {new BasicMeasurementMetrics.ReadingValueSource(Text.DELTA_SYMBOL + " " + Text.P_CCPCH, new DecibelStrategy(1), true, 12), new BasicMeasurementMetrics.ReadingValueSource(Text.DELTA_SYMBOL + " " + Text.S_CCPCH, new DecibelStrategy(1), true, 13), new BasicMeasurementMetrics.ReadingValueSource(Text.DELTA_SYMBOL + " " + Text.PICH, new DecibelStrategy(1), true, 9), new BasicMeasurementMetrics.ReadingValueSource(Text.DELTA_SYMBOL + " " + Text.P_SCH, new DecibelStrategy(1), true, 10), new BasicMeasurementMetrics.ReadingValueSource(Text.DELTA_SYMBOL + " " + Text.S_SCH, new DecibelStrategy(1), true, 11)}};
    }

    public UMTSMetrics(UMTSAnalyzer uMTSAnalyzer) {
        this.analyzer = uMTSAnalyzer;
    }

    private UMTSMeasurement getUmtsMeasurement() {
        return (UMTSMeasurement)this.getMeasurement();
    }

    protected boolean isMeasurementValid() {
        return this.getMeasurement().getIntegerReadingValue(3) != 0;
    }

    protected ValueSource createFreqErrorValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createFreqErrorValueSource(numberFieldStrategy, Text.Freq_Error);
    }

    protected ValueSource createEvmValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createEvmValueSource(numberFieldStrategy, Text.EVM);
    }

    protected ValueSource createPcdeValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createPcdeValueSource(numberFieldStrategy, Text.PCDE);
    }

    protected ValueSource createCarrFeedthruValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createCarrFeedthruValueSource(numberFieldStrategy, Text.Carr_Feedthru, Text.Carr_FT);
    }

    protected ValueSource createCpichValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createCpichValueSource(numberFieldStrategy, Text.CPICH);
    }

    private ValueSource createFreqErrorValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, false){

            protected long getRawValue() {
                return UMTSMetrics.this.getUmtsMeasurement().getFreqError();
            }

            public Color getValueColor() {
                if (UMTSMetrics.this.analyzer.isLimitOn(0)) {
                    return UMTSMetrics.this.analyzer.isFreqErrorWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + UMTSMetrics.this.getPassFailText(UMTSMetrics.this.analyzer.isLimitOn(0), UMTSMetrics.this.analyzer.isFreqErrorWithinLimits());
            }
        };
    }

    private ValueSource createEvmValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            protected long getRawValue() {
                return UMTSMetrics.this.getUmtsMeasurement().getEvm();
            }

            public Color getValueColor() {
                if (UMTSMetrics.this.analyzer.isLimitOn(1)) {
                    return UMTSMetrics.this.analyzer.isEvmWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + UMTSMetrics.this.getPassFailText(UMTSMetrics.this.analyzer.isLimitOn(1), UMTSMetrics.this.analyzer.isEvmWithinLimits());
            }
        };
    }

    private ValueSource createPcdeValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            protected long getRawValue() {
                return UMTSMetrics.this.getUmtsMeasurement().getPcde();
            }

            public Color getValueColor() {
                if (UMTSMetrics.this.analyzer.isLimitOn(2)) {
                    return UMTSMetrics.this.analyzer.isPcdeWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + UMTSMetrics.this.getPassFailText(UMTSMetrics.this.analyzer.isLimitOn(2), UMTSMetrics.this.analyzer.isPcdeWithinLimits());
            }
        };
    }

    private ValueSource createCarrFeedthruValueSource(NumberFieldStrategy numberFieldStrategy, String string, String string2) {
        return new TwoLabelValueSource(string, string2, numberFieldStrategy, true, 6){

            protected boolean useShortLabel() {
                return UMTSMetrics.this.analyzer.isLimitOn(3);
            }
        };
    }

    private ValueSource createCpichValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, false){

            protected long getRawValue() {
                return UMTSMetrics.this.getUmtsMeasurement().getCpich();
            }

            public Color getValueColor() {
                if (UMTSMetrics.this.analyzer.isLimitOn(3)) {
                    return UMTSMetrics.this.analyzer.isCpichWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + UMTSMetrics.this.getPassFailText(UMTSMetrics.this.analyzer.isLimitOn(3), UMTSMetrics.this.analyzer.isCpichWithinLimits());
            }
        };
    }

    private String getPassFailText(boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? " (P)" : " (F)";
        }
        return "";
    }

    protected boolean shouldGrayOutValues() {
        return false;
    }

    protected abstract class TwoLabelValueSource
    extends BasicMeasurementMetrics.ReadingValueSource {
        private String shortLabel;

        public TwoLabelValueSource(String string, String string2, NumberFieldStrategy numberFieldStrategy, boolean bl, int n) {
            super(string, numberFieldStrategy, bl, n);
            this.shortLabel = string2;
        }

        public String getLabel() {
            if (this.useShortLabel()) {
                return this.shortLabel;
            }
            return super.getLabel();
        }

        protected boolean useShortLabel() {
            return true;
        }
    }

    protected abstract class GrayableValueSource
    extends ValueSource {
        public GrayableValueSource(String string, NumberFieldStrategy numberFieldStrategy, boolean bl) {
            super(string, numberFieldStrategy, bl);
        }

        public Color getValueColor() {
            return UMTSMetrics.this.shouldGrayOutValues() ? Color.gray : Color.black;
        }
    }

    private class ScramblingCodeValueSource
    extends BasicMeasurementMetrics.ReadingValueSource {
        public ScramblingCodeValueSource(String string, NumberFieldStrategy numberFieldStrategy, boolean bl, int n) {
            super(string, numberFieldStrategy, bl, n);
        }

        protected long getRawValue() {
            if (UMTSMeasurementSettings.instance().getScramblingCodeAuto().intValue() == 1) {
                return super.getRawValue();
            }
            return UMTSMetrics.this.getMeasurement().getLongReadingValue(20);
        }

        public void compute(boolean bl) {
            if (UMTSMeasurementSettings.instance().getScramblingCodeAuto().intValue() == 1) {
                super.compute(bl);
            } else {
                super.compute(true);
            }
        }
    }
}

