/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.metrics.BasicMeasurementMetrics;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.tablelayout.TableLayoutConstraints;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.umts.CommonUMTSMeasurementSettings;
import elgato.measurement.umts.UMTSAnalyzer;
import elgato.measurement.umts.UMTSMeasurement;
import elgato.measurement.umts.UMTSOverAirMeasurement;
import elgato.measurement.umts.UMTSOverAirMeasurementSettings;
import elgato.measurement.umts.UMTSOverAirMetrics;
import elgato.measurement.umts.UMTSTopNChart;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class UMTSOverAirAnalyzer
extends UMTSAnalyzer {
    protected UMTSOverAirMeasurement measurement;
    UMTSTopNChart topNChart;

    public UMTSOverAirAnalyzer(CommonUMTSMeasurementSettings commonUMTSMeasurementSettings) {
        super(commonUMTSMeasurementSettings, "UmtsOaAnalyzer");
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    protected UMTSMeasurement getUMTSMeasurement() {
        return this.measurement;
    }

    protected void setMeasurement(Measurement measurement) {
        super.setMeasurement(measurement);
        this.measurement = (UMTSOverAirMeasurement)measurement;
    }

    protected int getIndexForXValue(long l) {
        return this.measurement.getIndexForXValue(l);
    }

    protected int getSpreadFactor(int n) {
        return this.measurement.getSpreadFactor(n);
    }

    protected int getChannelNumberForBar(int n) {
        return this.measurement.getChannelNumberForBar(n);
    }

    protected int getAbsBarPower(int n) {
        return this.measurement.getAbsBarPower(n);
    }

    protected int getAbsCdpTraceThreshold() {
        return this.measurement.getAbsCdpTraceThreshold();
    }

    protected TraceAnalyzer.AverageDynamicLabel createAverageLabelToTopChart() {
        return new TraceAnalyzer.AverageDynamicLabel(37, 38, 50);
    }

    protected BasicMeasurementMetrics createMetrics() {
        return new UMTSOverAirMetrics(this);
    }

    protected int getUMTSActuatorBase() {
        return 29;
    }

    protected UMTSAnalyzer.UMTSChartsPanel createChartsPanel() {
        return new UMTSOverAirChartsPanel(this);
    }

    private JPanel createTopNPanel(UMTSTopNChart uMTSTopNChart) {
        final DecibelStrategy decibelStrategy = new DecibelStrategy(0, false);
        final Resources resources = Resources.getResources("elgato.gui.topn");
        TableLayout tableLayout = new TableLayout(new float[][]{{-1.0f, 32.0f, 16.0f, 16.0f}, {-2.0f, -2.0f}});
        JPanel jPanel = new JPanel(tableLayout);
        jPanel.setBackground(null);
        jPanel.add((Component)new ELabel(Text.Pilot_Dominance, resources.getColor("label.color"), resources.getFont("label.font"), 4, 2), TableLayoutConstraints.newCell(0, 0));
        jPanel.add((Component)this.addLabel(new DynamicLabel(4, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                if (((UMTSOverAirMeasurement)measurement).isPilotDominanceAboveLimit()) {
                    this.setAttributes(resources.getColor("value.color.pass"), resources.getFont("value.font"));
                } else {
                    this.setAttributes(resources.getColor("value.color.fail"), resources.getFont("value.font"));
                }
                if (((UMTSOverAirMeasurement)measurement).getPilotDominance() == -1) {
                    return "< 0";
                }
                DecibelStrategy decibelStrategy = new DecibelStrategy(1, false);
                String[] stringArray = decibelStrategy.formatWithUnits(((UMTSOverAirMeasurement)measurement).getPilotDominance(), new String[2]);
                return stringArray[0];
            }
        }), TableLayoutConstraints.newCell(1, 0));
        jPanel.add((Component)this.addLabel(new DynamicLabel(3, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                return " " + decibelStrategy.getUnitString();
            }
        }), TableLayoutConstraints.newCell(2, 0));
        jPanel.add((Component)new ELabel(Text.Multipath_Power, resources.getColor("label.color"), resources.getFont("label.font"), 4, 2), TableLayoutConstraints.newCell(0, 1));
        jPanel.add((Component)this.addLabel(new DynamicLabel(4, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                boolean bl = ((UMTSOverAirMeasurement)measurement).isMultipathPowerBelowLimit();
                if (bl) {
                    this.setAttributes(resources.getColor("value.color.pass"), resources.getFont("value.font"));
                } else {
                    this.setAttributes(resources.getColor("value.color.fail"), resources.getFont("value.font"));
                }
                DecibelStrategy decibelStrategy = new DecibelStrategy(2, false);
                String[] stringArray = decibelStrategy.formatWithUnits(((UMTSOverAirMeasurement)measurement).getMultipathPower(), new String[2]);
                return stringArray[0];
            }
        }), TableLayoutConstraints.newCell(1, 1));
        jPanel.add((Component)this.addLabel(new DynamicLabel(3, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                return " " + decibelStrategy.getUnitString();
            }
        }), TableLayoutConstraints.newCell(2, 1));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add(uMTSTopNChart);
        jPanel2.setBackground(null);
        return jPanel2;
    }

    public TabDelimitable[] createReadingFields() {
        TabDelimitable[] tabDelimitableArray;
        int n = this.measurement.getNumBars();
        int[] nArray = this.measurement.getTopPnOffsets();
        int[] nArray2 = this.measurement.getTopNPilotsValues();
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        TabDelimitable[] tabDelimitableArray2 = this.metrics.getTabDelimitables();
        int n5 = tabDelimitableArray2.length;
        if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() == 1) {
            float f;
            int n6;
            String string;
            String string2;
            int n7;
            n3 = 8;
            tabDelimitableArray = new TabDelimitable[n5 + n + n3 + n2];
            for (n7 = 0; n7 < n5; ++n7) {
                tabDelimitableArray[n4++] = tabDelimitableArray2[n7];
            }
            n7 = UMTSOverAirMeasurementSettings.instance().isRelative() ? 1 : 0;
            int n8 = n7 != 0 ? this.measurement.getIntegerReadingValue(14) : this.measurement.getAbsCdpTraceThreshold();
            float f2 = this.convertPowerToFloat(n8);
            if (n7 != 0) {
                string2 = "Channel Power (dB)";
                string = "dB";
            } else {
                string2 = "Channel Power (dBm)";
                string = "dBm";
            }
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Trace Data");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Bar Count\t" + String.valueOf(n));
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("CDP Power Threshold\t" + String.valueOf(f2) + '\t' + string);
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Bar #\tChannel Number\t" + string2 + "\tSpread Factor\tActive/Inactive (1/0)");
            for (n6 = 0; n6 < n; ++n6) {
                int n9 = n7 != 0 ? this.measurement.getRelBarPower(n6) : this.measurement.getAbsBarPower(n6);
                f = this.convertPowerToFloat(n9);
                String string3 = String.valueOf(n6 + 1) + '\t' + String.valueOf(this.measurement.getChannelNumberForBar(n6)) + '\t' + String.valueOf(f) + '\t' + String.valueOf(this.measurement.getSpreadFactor(n6)) + '\t' + String.valueOf(this.measurement.isBarActive(n6) ? 1 : 0);
                tabDelimitableArray[n4++] = new TraceSaveTabDelimitable(string3);
            }
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Strongest Pilot's Scrambling Codes. -1 entries refer to the strongest SCH signals.");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Bar #\tScrambling Code\tRelative Power (dB)");
            for (n6 = 0; n6 < n2; ++n6) {
                f = this.convertPowerToFloat(nArray2[n6]);
                String string4 = nArray[n6] >= 0 ? String.valueOf(n6 + 1) + '\t' + String.valueOf(nArray[n6]) + '\t' + String.valueOf(f) + '\t' + "(CPICH)" : String.valueOf(n6 + 1) + '\t' + String.valueOf(nArray[n6]) + '\t' + String.valueOf(f) + '\t' + "(SCH)";
                tabDelimitableArray[n4++] = new TraceSaveTabDelimitable(string4);
            }
        } else {
            tabDelimitableArray = new TabDelimitable[n5];
            for (int i = 0; i < n5; ++i) {
                tabDelimitableArray[n4++] = tabDelimitableArray2[i];
            }
        }
        return tabDelimitableArray;
    }

    protected class UMTSOverAirChartsPanel
    extends UMTSAnalyzer.UMTSChartsPanel {
        private JPanel topNPanel;

        public UMTSOverAirChartsPanel(UMTSOverAirAnalyzer uMTSOverAirAnalyzer2) {
            super(UMTSOverAirAnalyzer.this, uMTSOverAirAnalyzer2);
            UMTSOverAirAnalyzer.this.controlChannelChart.setDisplayDeltaValues(true);
            UMTSOverAirAnalyzer.this.topNChart = new UMTSTopNChart();
            UMTSOverAirAnalyzer.this.topNChart.setVerticalRange(10000, 0);
            this.topNPanel = UMTSOverAirAnalyzer.this.createTopNPanel(UMTSOverAirAnalyzer.this.topNChart);
        }

        protected TraceChart getTopRightChart() {
            return UMTSOverAirAnalyzer.this.topNChart;
        }

        protected JComponent getTopRightPanel() {
            return this.topNPanel;
        }

        protected TraceChart getBottomRightChart() {
            return UMTSOverAirAnalyzer.this.controlChannelChart;
        }
    }
}

