/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.readings.BooleanReading;
import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import elgato.measurement.umts.UMTSMeasurement;
import elgato.measurement.umts.UMTSOverAirUnpacker;
import java.io.DataInput;
import java.io.IOException;

public class UMTSOverAirMeasurement
extends UMTSMeasurement {
    private static final long serialVersionUID = -3505941290581929945L;
    private static final Queue pool = new Queue(3);
    public static final int NUM_TOPN = 6;
    private IntegerReading currentPercentAmplifierCapacity = new IntegerReading();
    private IntegerReading peakPercentAmplifierCapacity = new IntegerReading();
    private IntegerReading averagePercentAmplifierCapacity = new IntegerReading();
    private IntegerReading currentPercentUtilization = new IntegerReading();
    private IntegerReading peakPercentUtilization = new IntegerReading();
    private IntegerReading averagePercentUtilization = new IntegerReading();
    private IntegerArrayReading topNPnOffsets = new IntegerArrayReading(6);
    private IntegerArrayReading topNPilots = new IntegerArrayReading(6);
    private IntegerReading pilotDominance = new IntegerReading();
    private IntegerReading multipathPower = new IntegerReading();
    private BooleanReading resetMetrics = new BooleanReading();
    private IntegerReading maxAmplifierCapacity = new IntegerReading();
    private IntegerReading pilotDominanceThreshold = new IntegerReading();
    private IntegerReading multipathPowerThreshold = new IntegerReading();
    private IntegerReading pilotPowerActuator = new IntegerReading();
    private IntegerReading pccpchChannelPower = new IntegerReading();
    public static final int SCRAMBLING_CODE = 0;
    public static final int FREQUENCY_ERROR = 1;
    public static final int CHANNEL_POWER = 2;
    public static final int CDP_VALID = 3;
    public static final int EVM = 4;
    public static final int PCDE = 5;
    public static final int CARRIER_FEEDTHROUGH = 6;
    public static final int NOISE_FLOOR = 7;
    public static final int CPICH = 8;
    public static final int DIFF_PICH_POWER = 9;
    public static final int DIFF_PSCH_POWER = 10;
    public static final int DIFF_SSCH_POWER = 11;
    public static final int DIFF_PCCPCH_POWER = 12;
    public static final int DIFF_SCCPCH_POWER = 13;
    public static final int CDP_TRACE_THRESHOLD = 14;
    public static final int NUM_BARS = 15;
    public static final int CDP_TRACE = 16;
    public static final int CDP_SPREAD_FACTORS = 17;
    public static final int CDP_CHANNEL_NUMBERS = 18;
    public static final int CURRENT_PERCENT_AMPLIFIER_CAPACITY = 19;
    public static final int PEAKER_PERCENT_AMPLIFIER_CAPACITY = 20;
    public static final int AVERAGE_PERCENT_AMPLIFIER_CAPACITY = 21;
    public static final int CURRENT_PERCENT_UTILIZATION = 22;
    public static final int PEAKER_PERCENT_UTILIZATION = 23;
    public static final int AVERAGE_PERCENT_UTILIZATION = 24;
    public static final int TOP_N_PNOFFSET = 25;
    public static final int TOP_N_PILOTS = 26;
    public static final int PILOT_DOMINANCE = 27;
    public static final int MULT_PATH_POWER = 28;
    public static final int ACTUATOR_ID_BASE = 29;
    public static final int FREQUENCY = 29;
    public static final int MANUAL_SCRAMBLING_CODE = 30;
    public static final int AUTO_SCRAMBLING_CODE_SEARCH = 31;
    public static final int SPEED_OF_THE_MEASUREMENT = 32;
    public static final int THRESHOLD_OFFSET = 33;
    public static final int THRESHOLD_OFFSET_LEVEL = 34;
    public static final int AUTO_THRESHOLD = 35;
    public static final int ATTENUATION = 36;
    public static final int AVERAGING_STATE = 37;
    public static final int NUM_AVERAGES = 38;
    public static final int SCCPCH_CH = 39;
    public static final int PICH_CH = 40;
    public static final int SCCPCH_SF = 41;
    public static final int SCCPCH_ENABLED = 42;
    public static final int PICH_ENABLED = 43;
    public static final int RESET_METRICS = 44;
    public static final int MAX_AMPLIFIER_CAPACITY = 45;
    public static final int PILOT_DOMINANCE_THRESHOLD = 46;
    public static final int MULTI_PATH_POWER_THRESHOLD = 47;
    public static final int PILOT_POWER = 48;
    public static final int PCCPCH_POWER = 49;
    public static final int AVERAGE_COUNT = 50;
    public static final int METRICS_ENABLED = 51;
    public static final int HSDPA_STATE = 52;
    public static final int IFEQ_STATUS = 53;
    public static final int EVM_MODE = 54;
    public static final int CDP_POWER = 55;
    private Reading[] readings = this.createReadings();

    public static UMTSMeasurement unpack(DataInput dataInput) throws IOException {
        UMTSOverAirUnpacker uMTSOverAirUnpacker = UMTSOverAirUnpacker.instance();
        UMTSOverAirMeasurement uMTSOverAirMeasurement = UMTSOverAirMeasurement.createOA();
        uMTSOverAirMeasurement = uMTSOverAirUnpacker.unpackMeasurement(uMTSOverAirMeasurement, dataInput);
        return uMTSOverAirMeasurement;
    }

    protected Reading[] getUMTSOverAirSensorReadings() {
        return new Reading[]{this.currentPercentAmplifierCapacity, this.peakPercentAmplifierCapacity, this.averagePercentAmplifierCapacity, this.currentPercentUtilization, this.peakPercentUtilization, this.averagePercentUtilization, this.topNPnOffsets, this.topNPilots, this.pilotDominance, this.multipathPower};
    }

    protected Reading[] getUMTSOverAirActuatorReadings() {
        return new Reading[]{this.resetMetrics, this.maxAmplifierCapacity, this.pilotDominanceThreshold, this.multipathPowerThreshold, this.pilotPowerActuator, this.pccpchChannelPower};
    }

    public Reading[] createReadings() {
        int n = this.getUMTSSensorReadings().length;
        int n2 = this.getUMTSOverAirSensorReadings().length;
        int n3 = this.getUMTSActuatorReadings().length;
        int n4 = this.getUMTSOverAirActuatorReadings().length;
        int n5 = this.getUMTSAddedReadingsGroupA().length;
        Reading[] readingArray = new Reading[n + n2 + n3 + n4 + n5];
        System.arraycopy(this.getUMTSSensorReadings(), 0, readingArray, 0, n);
        System.arraycopy(this.getUMTSOverAirSensorReadings(), 0, readingArray, n, n2);
        System.arraycopy(this.getUMTSActuatorReadings(), 0, readingArray, n + n2, n3);
        System.arraycopy(this.getUMTSOverAirActuatorReadings(), 0, readingArray, n + n2 + n3, n4);
        System.arraycopy(this.getUMTSAddedReadingsGroupA(), 0, readingArray, n + n2 + n3 + n4, n5);
        return readingArray;
    }

    static UMTSOverAirMeasurement createOA() {
        UMTSOverAirMeasurement uMTSOverAirMeasurement = (UMTSOverAirMeasurement)pool.dequeue();
        if (uMTSOverAirMeasurement == null) {
            return new UMTSOverAirMeasurement();
        }
        return uMTSOverAirMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public int getCurrentPercentAmplifierCapacity() {
        return this.currentPercentAmplifierCapacity.intValue();
    }

    public int getPeakPercentAmplifierCapacity() {
        return this.peakPercentAmplifierCapacity.intValue();
    }

    public int getAveragePercentAmplifierCapacity() {
        return this.averagePercentAmplifierCapacity.intValue();
    }

    public int getCurrentPercentUtilization() {
        return this.currentPercentUtilization.intValue();
    }

    public int getPeakPercentUtilization() {
        return this.peakPercentUtilization.intValue();
    }

    public int getAveragePercentUtilization() {
        return this.averagePercentUtilization.intValue();
    }

    public int[] getTopNPilotsValues() {
        return this.topNPilots.getTrace();
    }

    public int getPilotDominance() {
        return this.pilotDominance.intValue();
    }

    public int getMultipathPower() {
        return this.multipathPower.intValue();
    }

    public boolean isResetMetrics() {
        return this.resetMetrics.booleanValue();
    }

    public int getMaxAmplifierCapacity() {
        return this.maxAmplifierCapacity.intValue();
    }

    public int getPilotDominanceThreshold() {
        return this.pilotDominanceThreshold.intValue();
    }

    public int getMultipathPowerThreshold() {
        return this.multipathPowerThreshold.intValue();
    }

    public int getPilotPowerActuator() {
        return this.pilotPowerActuator.intValue();
    }

    public int getPCCPCHPowerActuator() {
        return this.pccpchChannelPower.intValue();
    }

    protected void setCurrentPercentAmplifierCapacity(int n) {
        this.currentPercentAmplifierCapacity.setValue(n);
    }

    protected void setPeakPercentAmplifierCapacity(int n) {
        this.peakPercentAmplifierCapacity.setValue(n);
    }

    protected void setAveragePercentAmplifierCapacity(int n) {
        this.averagePercentAmplifierCapacity.setValue(n);
    }

    protected void setCurrentPercentUtilization(int n) {
        this.currentPercentUtilization.setValue(n);
    }

    protected void setPeakPercentUtilization(int n) {
        this.peakPercentUtilization.setValue(n);
    }

    protected void setAveragePercentUtilization(int n) {
        this.averagePercentUtilization.setValue(n);
    }

    public void setTopNPilotValues(int[] nArray) {
        this.topNPilots.setTrace(nArray);
    }

    void setPilotDominance(int n) {
        this.pilotDominance.setValue(n);
    }

    void setMultipathPower(int n) {
        this.multipathPower.setValue(n);
    }

    void setResetMetrics(boolean bl) {
        this.resetMetrics.setValue(bl);
    }

    void setPilotPowerActuator(int n) {
        this.pilotPowerActuator.setValue(n);
    }

    void setMaxAmplifierCapacity(int n) {
        this.maxAmplifierCapacity.setValue(n);
    }

    void setPilotDominanceThreshold(int n) {
        this.pilotDominanceThreshold.setValue(n);
    }

    void setMultipathPowerThreshold(int n) {
        this.multipathPowerThreshold.setValue(n);
    }

    public int[] getTopPnOffsets() {
        return this.topNPnOffsets.getTrace();
    }

    public void setTopNPnOffsets(int[] nArray) {
        this.topNPnOffsets.setTrace(nArray);
    }

    public boolean isPilotDominanceAboveLimit() {
        return this.pilotDominance.intValue() > this.pilotDominanceThreshold.intValue();
    }

    public boolean isMultipathPowerBelowLimit() {
        return this.multipathPower.intValue() < this.multipathPowerThreshold.intValue();
    }

    public Reading[] getReadings() {
        return this.readings;
    }

    public String getMeasurementTitle() {
        return Text.WCDMA_Ovr_Air;
    }

    public void invalidatePilotDominance() {
        this.pilotDominance.setValue(-1);
    }
}

