/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.util.Text;
import elgato.measurement.umts.CommonUMTSMeasurementSettings;

public class UMTSOverAirMeasurementSettings
extends CommonUMTSMeasurementSettings {
    private static UMTSOverAirMeasurementSettings instance;
    public static final String TOPIC_UMTS_OA = "umtsOa";
    public static final int VALUE_UMTSOA_RESET_METRICS = 1;
    public static final String KEY_UMTSOA_MAX_PA = "ampCap";
    public static final String KEY_UMTSOA_PLT_DOM = "minPltDom";
    public static final String KEY_UMTSOA_PWR_THLD = "maxMp";
    public static final String KEY_UMTSOA_PLT_PWR = "pilotPwr";
    public static final String KEY_UMTSOA_PCCPCH_PWR = "pccpchPwr";
    public static final String KEY_UMTSOA_RESET_METRICS = "resetMetrics";
    private LongActuator resetMetrics;
    private LongActuator ampCap;
    private LongActuator pilotDominance;
    private LongActuator multipathPower;
    private LongActuator pilotPower;
    private LongActuator pccpchPower;

    protected UMTSOverAirMeasurementSettings() {
        super(TOPIC_UMTS_OA);
        this.resetMetrics = new LongActuator(this.TOPIC, KEY_UMTSOA_RESET_METRICS, Text.Reset_n_Metrics);
        this.ampCap = LongActuator.createWattsPower(this.TOPIC, KEY_UMTSOA_MAX_PA, Text.Max_PA_Pwr, "0.1", "300");
        this.pilotDominance = LongActuator.createPower(this.TOPIC, KEY_UMTSOA_PLT_DOM, Text.Plt_Dom);
        this.multipathPower = LongActuator.createPower(this.TOPIC, KEY_UMTSOA_PWR_THLD, Text.Mp_Pwr);
        this.pilotPower = LongActuator.createWattsPower(this.TOPIC, KEY_UMTSOA_PLT_PWR, Text.CPICH_Pwr, "0.1", "300");
        this.pccpchPower = LongActuator.createPower(this.TOPIC, KEY_UMTSOA_PCCPCH_PWR, Text.DeltaSymbol_Pccpch_Pwr);
        this.add(this.resetMetrics);
        this.add(this.ampCap);
        this.add(this.pilotDominance);
        this.add(this.multipathPower);
        this.add(this.pilotPower);
        this.add(this.pccpchPower);
        this.pilotDominance.setValidator(new RangeValidator(0L, 20000L));
        this.pilotDominance.setIncrement(100);
        this.multipathPower.setValidator(new RangeValidator(0L, 2000L));
        this.multipathPower.setIncrement(10);
        this.pccpchPower.setValidator(new RangeValidator(-50000L, 10000L));
        this.pccpchPower.setIncrement(1000);
        this.refresh();
    }

    public static UMTSOverAirMeasurementSettings instance() {
        if (instance == null) {
            instance = new UMTSOverAirMeasurementSettings();
            MeasurementSettings.logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            MeasurementSettings.logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    public LongActuator getResetMetrics() {
        return this.resetMetrics;
    }

    public LongActuator getAmpCap() {
        return this.ampCap;
    }

    public LongActuator getPilotDominance() {
        return this.pilotDominance;
    }

    public LongActuator getMultipathPower() {
        return this.multipathPower;
    }

    public LongActuator getPilotPower() {
        return this.pilotPower;
    }

    public LongActuator getPCCPCHPower() {
        return this.pccpchPower;
    }
}

