/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.Text;
import elgato.measurement.umts.CommonUMTSMeasurementSettings;
import elgato.measurement.umts.UMTSMenuMgr;
import elgato.measurement.umts.UMTSOverAirAnalyzer;
import elgato.measurement.umts.UMTSOverAirMeasurementSettings;
import elgato.measurement.umts.UMTSOverAirScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class UMTSOverAirMenuMgr
extends UMTSMenuMgr {
    public UMTSOverAirMenuMgr(UMTSOverAirScreen uMTSOverAirScreen, CommonUMTSMeasurementSettings commonUMTSMeasurementSettings, UMTSOverAirAnalyzer uMTSOverAirAnalyzer) {
        super(uMTSOverAirScreen, commonUMTSMeasurementSettings, uMTSOverAirAnalyzer);
    }

    protected SimpleMenuButton createDisplayMenu() {
        SimpleMenuButton simpleMenuButton = super.createDisplayMenu();
        Menu menu = simpleMenuButton.getMenu();
        simpleMenuButton.setText(Text.Display_slash_n_Reset);
        menu.setTitle(Text.Display_slash_n_Reset);
        menu.setMenuItem(this.createMetricsResetButton(), 6);
        return simpleMenuButton;
    }

    protected void createSetupMenus() {
        this.more1of2SetupMenu = new Menu(Text.Limits, new MenuItem[]{this.makeThresholdButton(), this.makeThresholdOffsetButton(), this.makeMeasTimeButton(), this.createHsdpaButton(), this.createAmpCapSettingsSubMenu(), this.createValidMeasSettingsSubMenu(), this.createMoreButton(Text.More_n_1_of_2)});
        this.more2of2SetupMenu = new Menu(Text.Setup, new MenuItem[]{this.sccpchButton, this.pichButton, this.createLimitsButton(), null, new MultiStateActuatorButton(this.settings.getEvmMode(), "", this.getListenerBaseName() + ".evmMode"), new MultiStateActuatorButton(this.settings.getEqStatus(), "", this.getListenerBaseName() + ".eqStatus"), this.createMore2Button(Text.More_n_2_of_2)});
    }

    private SubMenuButton createAmpCapSettingsSubMenu() {
        UMTSOverAirMeasurementSettings uMTSOverAirMeasurementSettings = UMTSOverAirMeasurementSettings.instance();
        Menu menu = new Menu(Text.Amp_Cap, new MenuItem[]{new MultiStateActuatorButton(SystemMeasurementSettings.instance().getAmpCap(), this.scn.getContextString("amp.cap.on.off"), this.scn.getListenerBaseName() + ".ampCapEnabledButton"), new ActuatorEditor(uMTSOverAirMeasurementSettings.getAmpCap(), this.scn.getContextString("max.amp.cap"), this.scn.getListenerBaseName() + ".maxCapButton"), new ActuatorEditor(uMTSOverAirMeasurementSettings.getPilotPower(), this.scn.getContextString("max.amp.cap"), this.scn.getListenerBaseName() + ".pltPwrButton"), new ActuatorEditor(uMTSOverAirMeasurementSettings.getPCCPCHPower(), this.scn.getContextString("max.amp.cap"), this.scn.getListenerBaseName() + ".pccpchPwrButton")});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Amp_Cap_n_Settings, this.scn.getContextString("amp.cap"), menu, true);
        subMenuButton.getCancelButton().setText(Text.Back);
        return subMenuButton;
    }

    private SubMenuButton createValidMeasSettingsSubMenu() {
        UMTSOverAirMeasurementSettings uMTSOverAirMeasurementSettings = UMTSOverAirMeasurementSettings.instance();
        Menu menu = new Menu(Text.Valid_Meas, new MenuItem[]{new ActuatorEditor(uMTSOverAirMeasurementSettings.getMultipathPower(), this.scn.getContextString("max.amp.cap"), this.scn.getListenerBaseName() + ".mpPwrButton"), new ActuatorEditor(uMTSOverAirMeasurementSettings.getPilotDominance(), this.scn.getContextString("max.amp.cap"), this.scn.getListenerBaseName() + ".pltDomButton")});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Valid_Meas_n_Settings, this.scn.getContextString("valid_meas"), menu, true);
        subMenuButton.getCancelButton().setText(Text.Back);
        return subMenuButton;
    }

    private MenuItem createMetricsResetButton() {
        return new PushButton(Text.Reset_n_Metrics, this.scn.getContextString("reset.metrics"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UMTSOverAirMeasurementSettings.instance().getResetMetrics().send(1L);
            }
        });
    }

    protected String getLeftMenuTitle() {
        boolean bl = MeasurementFactory.instance().optionAvailable("hsdpaAn");
        if (bl) {
            return Text.HSDPA_Ovr_Air;
        }
        return Text.WCDMA_Ovr_Air;
    }

    protected String getMeasurementName() {
        return "umtsOa";
    }
}

