/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.umts;

import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.metrics.BasicMeasurementMetrics;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.umts.UMTSOverAirAnalyzer;
import elgato.measurement.umts.UMTSOverAirMeasurement;
import elgato.measurement.umts.UMTSOverAirMeasurementSettings;
import java.awt.Color;

public class UMTSOverAirMetrics
extends BasicMeasurementMetrics {
    private UMTSOverAirAnalyzer analyzer;
    private NumberFieldStrategy percentStrategy = new FixedPointNumberFieldStrategy(1, " %");
    private NumberFieldStrategy freqStrategy = FrequencyStrategy.createWithMaxDecimalPlaces(3);
    private NumberFieldStrategy evmStrategy = new FixedPointNumberFieldStrategy(1, "%");
    private NumberFieldStrategy dbStrategy = new DecibelStrategy(1, true);
    private ValueSource freqErrorValueSource = this.createFreqErrorValueSource(this.freqStrategy);
    private ValueSource carrFeedthruValueSource = this.createCarrFeedthruValueSource(new FixedPointNumberFieldStrategy(1, "dBc"));
    private ValueSource evmValueSource = this.createEvmValueSource(this.evmStrategy);
    private ValueSource pcdeValueSource = this.createPcdeValueSource(new DecibelStrategy(1));
    private ValueSource cpichValueSource = this.createCpichValueSource(this.dbStrategy);
    public ValueListener evmModeListener;

    protected ValueSource[][] createValueSources() {
        this.percentStrategy = new FixedPointNumberFieldStrategy(1, " %");
        this.freqStrategy = FrequencyStrategy.createWithMaxDecimalPlaces(3);
        this.evmStrategy = new FixedPointNumberFieldStrategy(1, "%");
        this.dbStrategy = new DecibelStrategy(1, true);
        this.freqErrorValueSource = this.createFreqErrorValueSource(this.freqStrategy);
        this.carrFeedthruValueSource = this.createCarrFeedthruValueSource(new FixedPointNumberFieldStrategy(1, "dBc"));
        this.evmValueSource = this.createEvmValueSource(this.evmStrategy);
        this.pcdeValueSource = this.createPcdeValueSource(new DecibelStrategy(1));
        this.cpichValueSource = this.createCpichValueSource(this.dbStrategy);
        MaybeBlankValueSource maybeBlankValueSource = new MaybeBlankValueSource(this.percentStrategy, Text.Amp_Cap){

            public long getRawValue() {
                return UMTSOverAirMetrics.this.getUMTSOverAirMeasurement().getCurrentPercentAmplifierCapacity();
            }
        };
        MaybeBlankValueSource maybeBlankValueSource2 = new MaybeBlankValueSource(this.percentStrategy, Text.Pk_Amp_Cap){

            public long getRawValue() {
                return UMTSOverAirMetrics.this.getUMTSOverAirMeasurement().getPeakPercentAmplifierCapacity();
            }
        };
        MaybeBlankValueSource maybeBlankValueSource3 = new MaybeBlankValueSource(this.percentStrategy, Text.Avg_Amp_Cap){

            public long getRawValue() {
                return UMTSOverAirMetrics.this.getUMTSOverAirMeasurement().getAveragePercentAmplifierCapacity();
            }
        };
        ScramblingCodeValueSource scramblingCodeValueSource = new ScramblingCodeValueSource(Text.Scramble_Code, new NumberFieldStrategy(), true, 0);
        return new ValueSource[][]{{new BasicMeasurementMetrics.ReadingValueSource(Text.Freq, new FrequencyStrategy(), true, 29).setIgnoreValidFlag(true), this.freqErrorValueSource, scramblingCodeValueSource, new BasicMeasurementMetrics.ReadingValueSource(Text.Noise_Floor, new DecibelStrategy(1), true, 7), this.carrFeedthruValueSource}, {this.evmValueSource, this.pcdeValueSource, new BasicMeasurementMetrics.ReadingValueSource(Text.Utilization, this.percentStrategy, true, 22), new BasicMeasurementMetrics.ReadingValueSource(Text.Pk_Util, this.percentStrategy, true, 23), new BasicMeasurementMetrics.ReadingValueSource(Text.Avg_Util, this.percentStrategy, true, 24)}, {new BasicMeasurementMetrics.ReadingValueSource(Text.Chan_Pwr, new DecibelStrategy(1, true), true, 2).setIgnoreValidFlag(true), this.cpichValueSource, maybeBlankValueSource, maybeBlankValueSource2, maybeBlankValueSource3}};
    }

    public UMTSOverAirMetrics(UMTSOverAirAnalyzer uMTSOverAirAnalyzer) {
        this.analyzer = uMTSOverAirAnalyzer;
    }

    private UMTSOverAirMeasurement getUMTSOverAirMeasurement() {
        return (UMTSOverAirMeasurement)this.getMeasurement();
    }

    protected boolean isMeasurementValid() {
        return this.getMeasurement().getIntegerReadingValue(3) != 0;
    }

    protected boolean shouldGrayOutValues() {
        return false;
    }

    protected ValueSource createFreqErrorValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createFreqErrorValueSource(numberFieldStrategy, Text.Freq_Err);
    }

    protected ValueSource createCarrFeedthruValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createCarrFeedthruValueSource(numberFieldStrategy, Text.Carr_Feedthru, Text.Carr_FT);
    }

    protected ValueSource createEvmValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createEvmValueSource(numberFieldStrategy, Text.EVM);
    }

    protected ValueSource createPcdeValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createPcdeValueSource(numberFieldStrategy, Text.PCDE);
    }

    protected ValueSource createCpichValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createCpichValueSource(numberFieldStrategy, Text.CPICH);
    }

    private ValueSource createFreqErrorValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, false){

            protected long getRawValue() {
                return UMTSOverAirMetrics.this.getUMTSOverAirMeasurement().getFreqError();
            }

            public Color getValueColor() {
                if (UMTSOverAirMetrics.this.analyzer.isLimitOn(0)) {
                    return UMTSOverAirMetrics.this.analyzer.isFreqErrorWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + UMTSOverAirMetrics.this.getPassFailText(UMTSOverAirMetrics.this.analyzer.isLimitOn(0), UMTSOverAirMetrics.this.analyzer.isFreqErrorWithinLimits());
            }
        };
    }

    private ValueSource createCarrFeedthruValueSource(NumberFieldStrategy numberFieldStrategy, String string, String string2) {
        return new TwoLabelValueSource(string, string2, numberFieldStrategy, true, 6){

            protected boolean useShortLabel() {
                return UMTSOverAirMetrics.this.analyzer.isLimitOn(0);
            }
        };
    }

    private ValueSource createEvmValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            protected long getRawValue() {
                return UMTSOverAirMetrics.this.getUMTSOverAirMeasurement().getEvm();
            }

            public Color getValueColor() {
                if (UMTSOverAirMetrics.this.analyzer.isLimitOn(1)) {
                    return UMTSOverAirMetrics.this.analyzer.isEvmWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + UMTSOverAirMetrics.this.getPassFailText(UMTSOverAirMetrics.this.analyzer.isLimitOn(1), UMTSOverAirMetrics.this.analyzer.isEvmWithinLimits());
            }
        };
    }

    private ValueSource createPcdeValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            protected long getRawValue() {
                return UMTSOverAirMetrics.this.getUMTSOverAirMeasurement().getPcde();
            }

            public Color getValueColor() {
                if (UMTSOverAirMetrics.this.analyzer.isLimitOn(2)) {
                    return UMTSOverAirMetrics.this.analyzer.isPcdeWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + UMTSOverAirMetrics.this.getPassFailText(UMTSOverAirMetrics.this.analyzer.isLimitOn(2), UMTSOverAirMetrics.this.analyzer.isPcdeWithinLimits());
            }
        };
    }

    private ValueSource createCpichValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, false){

            protected long getRawValue() {
                return UMTSOverAirMetrics.this.getUMTSOverAirMeasurement().getCpich();
            }

            public Color getValueColor() {
                if (UMTSOverAirMetrics.this.analyzer.isLimitOn(3)) {
                    return UMTSOverAirMetrics.this.analyzer.isCpichWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + UMTSOverAirMetrics.this.getPassFailText(UMTSOverAirMetrics.this.analyzer.isLimitOn(3), UMTSOverAirMetrics.this.analyzer.isCpichWithinLimits());
            }
        };
    }

    private String getPassFailText(boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? " (P)" : " (F)";
        }
        return "";
    }

    private class ScramblingCodeValueSource
    extends BasicMeasurementMetrics.ReadingValueSource {
        public ScramblingCodeValueSource(String string, NumberFieldStrategy numberFieldStrategy, boolean bl, int n) {
            super(string, numberFieldStrategy, bl, n);
        }

        protected long getRawValue() {
            if (UMTSOverAirMeasurementSettings.instance().getScramblingCodeAuto().intValue() == 1) {
                return super.getRawValue();
            }
            return UMTSOverAirMetrics.this.getUMTSOverAirMeasurement().getLongReadingValue(30);
        }

        public void compute(boolean bl) {
            if (UMTSOverAirMeasurementSettings.instance().getScramblingCodeAuto().intValue() == 1) {
                super.compute(bl);
            } else {
                super.compute(true);
            }
        }
    }

    protected abstract class TwoLabelValueSource
    extends BasicMeasurementMetrics.ReadingValueSource {
        private String shortLabel;

        public TwoLabelValueSource(String string, String string2, NumberFieldStrategy numberFieldStrategy, boolean bl, int n) {
            super(string, numberFieldStrategy, bl, n);
            this.shortLabel = string2;
        }

        public String getLabel() {
            if (this.useShortLabel()) {
                return this.shortLabel;
            }
            return super.getLabel();
        }

        protected boolean useShortLabel() {
            return true;
        }
    }

    private abstract class MaybeBlankValueSource
    extends GrayableValueSource {
        public MaybeBlankValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
            super(string, numberFieldStrategy, true);
        }

        public void compute(boolean bl) {
            if (SystemMeasurementSettings.displayAmpCap()) {
                super.compute(bl);
            } else {
                this.setResultsEmpty();
            }
        }
    }

    protected abstract class GrayableValueSource
    extends ValueSource {
        public GrayableValueSource(String string, NumberFieldStrategy numberFieldStrategy, boolean bl) {
            super(string, numberFieldStrategy, bl);
        }

        public Color getValueColor() {
            return UMTSOverAirMetrics.this.shouldGrayOutValues() ? Color.gray : Color.black;
        }
    }
}

